/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSUserDefinedHeaderSegment;
import gov.nasa.worldwind.formats.rpf.RPFFileComponents;
import gov.nasa.worldwind.util.StringUtil;
import java.nio.ByteBuffer;

public class RPFUserDefinedHeaderSegment
extends NITFSUserDefinedHeaderSegment {
    private RPFFileComponents components;

    public RPFUserDefinedHeaderSegment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        if (!StringUtil.Equals("RPFHDR", this.dataTag)) {
            throw new NITFSRuntimeException("NITFSReader.RPFHeaderNotFoundInUserDefinedSegment", this.dataTag);
        }
        this.components = new RPFFileComponents(byteBuffer);
        this.restoreBufferPosition();
    }

    public RPFFileComponents getRPFFileComponents() {
        return this.components;
    }
}

