/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RPFProducer {
    PRODUCER_1(Character.valueOf('1'), "AFACC", "Air Force Air Combat Command"),
    PRODUCER_2(Character.valueOf('2'), "AFESC", "Air Force Electronic Systems Center"),
    PRODUCER_3(Character.valueOf('3'), "NIMA", "National Imagery and Mapping Agency, Primary"),
    PRODUCER_4(Character.valueOf('4'), "NIMA1", "NIMA, Alternate Site 1"),
    PRODUCER_5(Character.valueOf('5'), "NIMA2", "NIMA, Alternate Site 2"),
    PRODUCER_6(Character.valueOf('6'), "NIMA3", "NIMA, Alternate Site 3"),
    PRODUCER_7(Character.valueOf('7'), "SOCAF", "Air Force Special Operations Command"),
    PRODUCER_8(Character.valueOf('8'), "SOCOM", "United States Special Operations Command"),
    PRODUCER_9(Character.valueOf('9'), "PACAF", "Pacific Air Forces"),
    PRODUCER_A(Character.valueOf('A'), "USAFE", "United States Air Force, Europe"),
    PRODUCER_B(Character.valueOf('B'), "Non-DoD (NonDD)", "US producer outside the Department of Defense"),
    PRODUCER_C(Character.valueOf('C'), "Non-US (NonUS)", "Non-US producer"),
    PRODUCER_D(Character.valueOf('D'), "NIMA", "DCHUM (DCHUM) NIMA produced Digital CHUM file"),
    PRODUCER_E(Character.valueOf('E'), "Non-NIMA DCHUM (DCHMD)", "DoD producer of Digital CHUM file otherthan NIMA "),
    PRODUCER_F(Character.valueOf('F'), "Non-US DCHUM (DCHMF)", "Non-US (foreign)producer of Digital CHUMfiles"),
    PRODUCER_G(Character.valueOf('G'), "Non-DoD DCHUM (DCHMG)", "US producer of Digital CHUM files outsideDoD"),
    PRODUCER_H(Character.valueOf('H'), "IMG2RPF", "Non-specified, Imagery formatted to RPF");

    public final Character id;
    public final String producerCode;
    public final String producer;
    private static RPFProducer[] enumConstantAlphabet;

    private RPFProducer(Character c, String string2, String string3) {
        this.id = c;
        this.producer = string3;
        this.producerCode = string2;
    }

    private static synchronized RPFProducer[] enumConstantAlphabet() {
        if (enumConstantAlphabet == null) {
            RPFProducer[] rPFProducerArray = (RPFProducer[])RPFProducer.class.getEnumConstants();
            enumConstantAlphabet = new RPFProducer[36];
            RPFProducer[] rPFProducerArray2 = rPFProducerArray;
            int n = rPFProducerArray2.length;
            for (int i = 0; i < n; ++i) {
                RPFProducer rPFProducer;
                RPFProducer.enumConstantAlphabet[RPFProducer.indexFor((Character)rPFProducer.id)] = rPFProducer = rPFProducerArray2[i];
            }
        }
        return enumConstantAlphabet;
    }

    private static int indexFor(Character c) {
        if (c.charValue() >= '0' && c.charValue() <= '9') {
            return c.charValue() - 48;
        }
        if (c.charValue() >= 'A' && c.charValue() <= 'Z') {
            return 10 + c.charValue() - 65;
        }
        return -1;
    }

    public static boolean isProducerId(Character c) {
        if (c == null) {
            String string = Logging.getMessage("nullValue.CharacterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RPFProducer[] rPFProducerArray = RPFProducer.enumConstantAlphabet();
        int n = RPFProducer.indexFor(Character.valueOf(Character.toUpperCase(c.charValue())));
        return n >= 0 && n < rPFProducerArray.length && rPFProducerArray[n] != null;
    }

    public static RPFProducer producerFor(Character c) {
        RPFProducer rPFProducer;
        if (c == null) {
            String string = Logging.getMessage("nullValue.CharacterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RPFProducer[] rPFProducerArray = RPFProducer.enumConstantAlphabet();
        int n = RPFProducer.indexFor(Character.valueOf(Character.toUpperCase(c.charValue())));
        if (n < 0 || n >= rPFProducerArray.length || (rPFProducer = rPFProducerArray[n]) == null) {
            String string = Logging.getMessage("generic.EnumNotFound", c);
            Logging.logger().severe(string);
            throw new EnumConstantNotPresentException(RPFZone.class, string);
        }
        return rPFProducer;
    }

    static {
        enumConstantAlphabet = null;
    }
}

