/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFZone;

class RPFFrameStructure {
    static final int PIXEL_ROWS_PER_FRAME = 1536;
    static final int SUBFRAME_ROWS_PER_FRAME = 6;
    private static final int NORTH_SOUTH_PIXEL_SPACING_CONSTANT = 400384;
    private static final int[] EAST_WEST_PIXEL_SPACING_CONSTANT = new int[]{369664, 302592, 245760, 199168, 163328, 137216, 110080, 82432};
    private static final int[] EQUATORWARD_NOMINAL_BOUNDARY = new int[]{0, 32, 48, 56, 64, 68, 72, 76, 80};
    private static final int[] POLEWARD_NOMINAL_BOUNDARY = new int[]{32, 48, 56, 64, 68, 72, 76, 80, 90};

    RPFFrameStructure() {
    }

    public final int getPixelRowsPerFrame() {
        return 1536;
    }

    public final int getSubframeRowsPerFrame() {
        return 6;
    }

    static int eastWestPixelSpacingConstant(char c) {
        int n = RPFZone.indexFor(c) % 9;
        if (n < 0) {
            return -1;
        }
        return EAST_WEST_PIXEL_SPACING_CONSTANT[n];
    }

    static int northSouthPixelSpacingConstant() {
        return 400384;
    }

    static int equatorwardNominalBoundary(char c) {
        return RPFFrameStructure.nominalBoundary(c, EQUATORWARD_NOMINAL_BOUNDARY);
    }

    static int polewardNominalBoundary(char c) {
        return RPFFrameStructure.nominalBoundary(c, POLEWARD_NOMINAL_BOUNDARY);
    }

    private static int nominalBoundary(char c, int[] nArray) {
        int n = RPFZone.indexFor(c) % 9;
        if (n < 0) {
            return -1;
        }
        if (!RPFZone.isZoneInUpperHemisphere(c)) {
            return 0 - nArray[n];
        }
        return nArray[n];
    }
}

