/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.DDSConverter;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.swing.JFileChooser;

public class StandaloneDDSConverter {
    private static void convertToDDS(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            String string = Logging.getMessage("DDSConverter.NoFileOrNoPermission");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file.isDirectory()) {
            StandaloneDDSConverter.convertDirectory(file, new String[]{".jpg", "png"});
        } else {
            StandaloneDDSConverter.convertFile(file);
        }
    }

    private static void convertDirectory(File file, final String[] stringArray) {
        File[] fileArray;
        System.out.printf("===== Converting Directory %s\n", file.getPath());
        File[] fileArray2 = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                for (String string : stringArray) {
                    if (!file.getPath().endsWith(string)) continue;
                    return true;
                }
                return false;
            }
        });
        if (fileArray2 != null) {
            fileArray = fileArray2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                try {
                    StandaloneDDSConverter.convertFile(file2);
                    continue;
                }
                catch (Exception exception) {
                    System.out.printf("Exception converting %s, skipping file\n", file2.getPath());
                    exception.printStackTrace();
                }
            }
        }
        if ((fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null) {
            for (File file3 : fileArray) {
                StandaloneDDSConverter.convertDirectory(file3, stringArray);
            }
        }
    }

    private static void convertFile(File file) throws IOException {
        System.out.printf("Converting File %s\n", file.getPath());
        ByteBuffer byteBuffer = DDSConverter.convertToDDS(file);
        File file2 = new File(WWIO.replaceSuffix(file.getPath(), ".dds"));
        WWIO.saveBuffer(byteBuffer, file2);
    }

    public static void main(String[] stringArray) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(null);
        if (n != 0) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        if (fileArray == null) {
            System.out.println("No files selected");
            return;
        }
        for (File file : fileArray) {
            try {
                StandaloneDDSConverter.convertToDDS(file);
            }
            catch (IOException iOException) {
                System.out.printf("Exception converting input file %s, skipping file\n", file.getPath());
                iOException.printStackTrace();
            }
        }
    }
}

