/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewLookAround
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind View Look Around", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private ViewControlPanel vcp = new ViewControlPanel(this.getWwd());

        public AppFrame() {
            super(true, true, false);
            this.getLayerPanel().add((Component)this.vcp, "South");
        }

        private class ViewControlPanel
        extends JPanel {
            private WorldWindow wwd;
            private JSlider pitchSlider;
            private JSlider headingSlider;
            private JSlider fovSlider;
            private boolean suspendEvents = false;

            public ViewControlPanel(WorldWindow worldWindow) {
                this.wwd = worldWindow;
                this.wwd.getView().addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        ViewControlPanel.this.update();
                    }
                });
                this.setLayout(new BoxLayout(this, 1));
                JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
                jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel.add(new JLabel("Pitch:"));
                this.pitchSlider = new JSlider(0, 90, 0);
                this.pitchSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        ViewControlPanel.this.updateView();
                    }
                });
                jPanel.add(this.pitchSlider);
                JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 5, 5));
                jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel2.add(new JLabel("Heading:"));
                this.headingSlider = new JSlider(-180, 180, 0);
                this.headingSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        ViewControlPanel.this.updateView();
                    }
                });
                jPanel2.add(this.headingSlider);
                JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 5, 5));
                jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel3.add(new JLabel("Field of view:"));
                this.fovSlider = new JSlider(10, 120, 45);
                this.fovSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        ViewControlPanel.this.updateView();
                    }
                });
                jPanel3.add(this.fovSlider);
                this.add(jPanel);
                this.add(jPanel2);
                this.add(jPanel3);
                this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("View")));
                this.setToolTipText("View controls");
            }

            private void updateView() {
                if (!this.suspendEvents) {
                    OrbitView orbitView = (OrbitView)this.wwd.getView();
                    orbitView.stopStateIterators();
                    Position position = orbitView.getEyePosition();
                    orbitView.setHeading(Angle.fromDegrees(this.headingSlider.getValue()));
                    orbitView.setPitch(Angle.fromDegrees(this.pitchSlider.getValue()));
                    orbitView.setFieldOfView(Angle.fromDegrees(this.fovSlider.getValue()));
                    orbitView.setZoom(0.0);
                    orbitView.setCenterPosition(position);
                    this.wwd.redraw();
                }
            }

            public void update() {
                this.suspendEvents = true;
                OrbitView orbitView = (OrbitView)this.wwd.getView();
                this.pitchSlider.setValue((int)orbitView.getPitch().degrees);
                this.headingSlider.setValue((int)orbitView.getHeading().degrees);
                this.fovSlider.setValue((int)orbitView.getFieldOfView().degrees);
                this.suspendEvents = false;
            }
        }
    }
}

