/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.view.EyePositionIterator;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.ScheduledOrbitViewStateIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ViewIteration
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        try {
            AppFrame appFrame = new AppFrame();
            appFrame.setTitle("World Wind View Paths");
            appFrame.setDefaultCloseOperation(3);
            appFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class AppFrame
    extends JFrame {
        static ArrayList<Position> path = new ArrayList();
        private int pathPosition = 0;
        private PathAction[] pathActions = new PathAction[]{new GoToLatLonFromCurrent("Zero", LatLon.ZERO), new FollowPath("Follow"), new Heading("Heading"), new Forward("Forward"), new Backwards("Backwards")};
        private Dimension canvasSize = new Dimension(800, 600);
        private ApplicationTemplate.AppPanel wwjPanel = new ApplicationTemplate.AppPanel(this.canvasSize, true);

        public AppFrame() {
            this.wwjPanel.setPreferredSize(this.canvasSize);
            JPanel jPanel = this.makeControlPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            this.getContentPane().add((Component)jPanel, "West");
            this.pack();
            Dimension dimension = this.getPreferredSize();
            Point point = new Point(0, 0);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + (dimension2.width - dimension.width) / 2;
            int n2 = point.y + (dimension2.height - dimension.height) / 2;
            this.setLocation(n, n2);
            this.setResizable(true);
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel(new GridLayout(8, 1));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Go To"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            for (PathAction pathAction : this.pathActions) {
                JButton jButton = new JButton(pathAction);
                jPanel.add(jButton);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "Center");
            return jPanel2;
        }

        private Angle computeHeading(Position position, Position position2) {
            return LatLon.greatCircleAzimuth(position.getLatLon(), position2.getLatLon());
        }

        static {
            path.add(Position.fromDegrees(0.0, 0.0, 100000.0));
            path.add(Position.fromDegrees(0.0, 10.0, 100000.0));
            path.add(Position.fromDegrees(0.0, 20.0, 100000.0));
            path.add(Position.fromDegrees(0.0, 30.0, 100000.0));
            path.add(Position.fromDegrees(0.0, 40.0, 100000.0));
            path.add(Position.fromDegrees(0.0, 50.0, 100000.0));
            path.add(Position.fromDegrees(0.0, 60.0, 100000.0));
            path.add(Position.fromDegrees(0.0, 70.0, 100000.0));
        }

        private class FollowPath
        extends PathAction {
            ArrayList<Position> path;

            FollowPath(String string) {
                super(string);
                this.path = new ArrayList();
                this.path.add(Position.fromDegrees(0.0, 0.0, 100000.0));
                this.path.add(Position.fromDegrees(1.0, 3.0, 100000.0));
                this.path.add(Position.fromDegrees(2.0, 4.0, 100000.0));
                this.path.add(Position.fromDegrees(3.0, 5.0, 100000.0));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                for (Position position : this.path) {
                    OrbitView orbitView = (OrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                    EyePositionIterator eyePositionIterator = new EyePositionIterator(4000L, orbitView.getEyePosition(), new Position(position.getLatLon(), orbitView.getEyePosition().getElevation()));
                    AppFrame.this.wwjPanel.getWwd().getView().applyStateIterator(eyePositionIterator);
                }
            }

            private class PosToPos
            implements Runnable {
                Position pos;

                PosToPos(Position position) {
                    this.pos = position;
                }

                public void run() {
                    OrbitView orbitView = (OrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                    EyePositionIterator eyePositionIterator = new EyePositionIterator(4000L, orbitView.getEyePosition(), this.pos);
                    AppFrame.this.wwjPanel.getWwd().getView().applyStateIterator(eyePositionIterator);
                }
            }
        }

        private class GoToLatLonFromCurrent
        extends PathAction {
            private final LatLon latlon;

            GoToLatLonFromCurrent(String string, LatLon latLon) {
                super(string);
                this.latlon = latLon;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OrbitView orbitView = (OrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                EyePositionIterator eyePositionIterator = new EyePositionIterator(4000L, orbitView.getEyePosition(), new Position(this.latlon, orbitView.getEyePosition().getElevation()));
                AppFrame.this.wwjPanel.getWwd().getView().applyStateIterator(eyePositionIterator);
            }
        }

        private class Heading
        extends PathAction {
            public Heading(String string) {
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Angle angle = AppFrame.this.pathPosition == 0 ? AppFrame.this.computeHeading(path.get(0), path.get(1)) : AppFrame.this.computeHeading(path.get(AppFrame.this.pathPosition - 1), path.get(AppFrame.this.pathPosition));
                OrbitView orbitView = (OrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                ScheduledOrbitViewStateIterator scheduledOrbitViewStateIterator = ScheduledOrbitViewStateIterator.createHeadingIterator(orbitView.getHeading(), angle);
                AppFrame.this.wwjPanel.getWwd().getView().applyStateIterator(scheduledOrbitViewStateIterator);
            }
        }

        private class Backwards
        extends PathAction {
            public Backwards(String string) {
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (AppFrame.this.pathPosition > 0) {
                    OrbitView orbitView = (OrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                    EyePositionIterator eyePositionIterator = new EyePositionIterator(4000L, orbitView.getEyePosition(), path.get(--AppFrame.this.pathPosition));
                    AppFrame.this.wwjPanel.getWwd().getView().applyStateIterator(eyePositionIterator);
                }
            }
        }

        private class Forward
        extends PathAction {
            public Forward(String string) {
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (AppFrame.this.pathPosition < path.size() - 1) {
                    OrbitView orbitView = (OrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                    orbitView.setHeading(Angle.fromDegrees(90.0));
                    EyePositionIterator eyePositionIterator = new EyePositionIterator(4000L, orbitView.getEyePosition(), path.get(++AppFrame.this.pathPosition));
                    AppFrame.this.wwjPanel.getWwd().getView().applyStateIterator(eyePositionIterator);
                }
            }
        }

        private abstract class PathAction
        extends AbstractAction {
            PathAction(String string) {
                super(string);
            }
        }
    }
}

