/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.formats.tiff.GeotiffImageReaderSpi;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;

public class SurfaceImageLayer
extends RenderableLayer {
    private ConcurrentHashMap<String, SurfaceImage> imageTable = new ConcurrentHashMap();

    public void addImage(String string) throws IOException {
        Sector sector;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ImageSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        File file2 = SurfaceImageLayer.getWorldFile(file.getAbsoluteFile());
        if (file2 == null || !file2.exists()) {
            System.out.println("World file for " + string + "does not exist");
        }
        if ((sector = SurfaceImageLayer.decodeWorldFile(file2, bufferedImage.getWidth(), bufferedImage.getHeight())) == null) {
            System.out.println("World file for " + string + "can not be decoded");
        }
        if (this.imageTable.contains(string)) {
            this.removeImage(string);
        }
        SurfaceImage surfaceImage = new SurfaceImage(bufferedImage, sector);
        surfaceImage.setOpacity(this.getOpacity());
        this.addRenderable(surfaceImage);
        this.imageTable.put(string, surfaceImage);
    }

    public void removeImage(String string) {
        SurfaceImage surfaceImage = this.imageTable.get(string);
        if (surfaceImage != null) {
            this.removeRenderable(surfaceImage);
            this.imageTable.remove(string);
        }
    }

    public void setOpacity(double d) {
        super.setOpacity(d);
        for (Map.Entry<String, SurfaceImage> entry : this.imageTable.entrySet()) {
            entry.getValue().setOpacity(d);
        }
    }

    private static File getWorldFile(File file) {
        String string;
        File file2 = file.getParentFile();
        File[] fileArray = file2.listFiles(new FilenameFilter(string = WWIO.replaceSuffix(file.getName(), "")){
            final /* synthetic */ String val$base;
            {
                this.val$base = string;
            }

            public boolean accept(File file, String string) {
                return string.startsWith(this.val$base) && string.toLowerCase().endsWith("w");
            }
        });
        return fileArray != null && fileArray.length > 0 ? fileArray[0] : null;
    }

    private static Sector decodeWorldFile(File file, int n, int n2) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            if (!scanner.hasNextDouble()) {
                System.out.println("World file missing value at line " + (i + 1));
                return null;
            }
            dArray[i] = scanner.nextDouble();
        }
        Sector sector = SurfaceImageLayer.parseDegrees(dArray, n, n2);
        return sector;
    }

    private static Sector parseDegrees(double[] dArray, int n, int n2) {
        Angle angle;
        Angle angle2;
        Angle angle3;
        Angle angle4;
        Angle angle5 = Angle.fromDegrees(dArray[5]);
        Angle angle6 = angle5.addDegrees(dArray[3] * (double)n2);
        Angle angle7 = Angle.fromDegrees(dArray[4]);
        Angle angle8 = angle7.addDegrees(dArray[0] * (double)n);
        if (angle7.degrees < angle8.degrees) {
            angle4 = angle7;
            angle3 = angle8;
        } else {
            angle4 = angle8;
            angle3 = angle7;
        }
        if (angle7.degrees < angle8.degrees) {
            angle2 = angle5;
            angle = angle6;
        } else {
            angle2 = angle6;
            angle = angle5;
        }
        return new Sector(angle2, angle, angle4, angle3);
    }

    static {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        iIORegistry.registerServiceProvider(GeotiffImageReaderSpi.inst());
    }
}

