/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Quadrilateral;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceSector;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.render.WWIcon;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Shapes {
    private static final String APP_NAME = "World Wind Shapes";

    public static void main(String[] stringArray) {
        try {
            AppFrame appFrame = new AppFrame();
            appFrame.setTitle(APP_NAME);
            appFrame.setDefaultCloseOperation(3);
            appFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", APP_NAME);
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }

    protected static class AppFrame
    extends JFrame {
        private Dimension canvasSize = new Dimension(800, 600);
        private ApplicationTemplate.AppPanel wwjPanel;
        private RenderableLayer layer = new RenderableLayer();
        private TextRenderer textRenderer = new TextRenderer(Font.decode("Arial-Plain-13"), true, true);
        private Renderable currentShape;
        private String currentPathColor = "Yellow";
        private int currentPathOpacity = 10;
        private float currentPathWidth = 1.0f;
        private String currentPathType = "Great Circle";
        private String currentPathStyle = "Solid";
        private boolean currentFollowTerrain = true;
        private float currentOffset = 0.0f;
        private int currentTerrainConformance = 10;
        private int currentNumSubsegments = 10;
        private String currentBorderColor = "Yellow";
        private float currentBorderWidth = 1.0f;
        private int currentBorderOpacity = 10;
        private String currentBorderStyle = "Solid";
        private String currentInteriorColor = "Yellow";
        private int currentInteriorOpacity = 10;
        private String currentInteriorStyle = "Solid";
        private String currentImage = null;
        private int currentTextureWidth = 128;
        private int currentTextureHeight = 128;
        private ArrayList<JComponent> onTerrainOnlyItems = new ArrayList();
        private ArrayList<JComponent> offTerrainOnlyItems = new ArrayList();

        public AppFrame() {
            this.wwjPanel = new ApplicationTemplate.AppPanel(this.canvasSize, true);
            this.wwjPanel.setPreferredSize(this.canvasSize);
            ApplicationTemplate.insertBeforePlacenames(this.wwjPanel.getWwd(), this.layer);
            JPanel jPanel = this.makeShapeSelectionPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel2 = this.makeAttributesPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel, "Center");
            JPanel jPanel4 = new JPanel(new BorderLayout(6, 6));
            jPanel4.add((Component)jPanel2, "Center");
            jPanel3.add((Component)jPanel4, "South");
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            this.getContentPane().add((Component)jPanel3, "West");
            this.pack();
            Dimension dimension = this.getPreferredSize();
            Point point = new Point(0, 0);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + (dimension2.width - dimension.width) / 2;
            int n2 = point.y + (dimension2.height - dimension.height) / 2;
            this.setLocation(n, n2);
            this.setResizable(true);
            this.wwjPanel.getWwd().addRenderingListener(new RenderingListener(){

                public void stageChanged(RenderingEvent renderingEvent) {
                    if (!renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.BeforeBufferSwap")) {
                        return;
                    }
                    if (AppFrame.this.currentShape instanceof Polyline) {
                        Polyline polyline = (Polyline)AppFrame.this.currentShape;
                        String string = Double.toString(polyline.getLength());
                        AppFrame.this.textRenderer.beginRendering(AppFrame.this.wwjPanel.getWidth(), AppFrame.this.wwjPanel.getHeight());
                        AppFrame.this.textRenderer.draw(string, 100, 100);
                        AppFrame.this.textRenderer.endRendering();
                    }
                }
            });
            this.setupSelection();
        }

        private void update() {
            for (Serializable serializable : this.onTerrainOnlyItems) {
                serializable.setEnabled(this.currentFollowTerrain);
            }
            for (Serializable serializable : this.offTerrainOnlyItems) {
                serializable.setEnabled(!this.currentFollowTerrain);
            }
            if (this.currentShape instanceof SurfaceShape) {
                Color color;
                SurfaceShape surfaceShape = (SurfaceShape)this.currentShape;
                if (!this.currentBorderStyle.equals("None")) {
                    float f = this.currentBorderOpacity >= 10 ? 1.0f : (this.currentBorderOpacity <= 0 ? 0.0f : (float)this.currentBorderOpacity / 10.0f);
                    color = null;
                    if (this.currentBorderColor.equals("Yellow")) {
                        color = new Color(1.0f, 1.0f, 0.0f, f);
                    } else if (this.currentBorderColor.equals("Red")) {
                        color = new Color(1.0f, 0.0f, 0.0f, f);
                    } else if (this.currentBorderColor.equals("Green")) {
                        color = new Color(0.0f, 1.0f, 0.0f, f);
                    } else if (this.currentBorderColor.equals("Blue")) {
                        color = new Color(0.0f, 0.0f, 1.0f, f);
                    }
                    BasicStroke basicStroke = null;
                    surfaceShape.setBorderColor(color);
                    if (this.currentBorderStyle.equals("Solid")) {
                        basicStroke = new BasicStroke(this.currentBorderWidth);
                    } else if (this.currentBorderStyle.equals("Dash")) {
                        basicStroke = new BasicStroke(this.currentBorderWidth, 0, 0, 2.0f, new float[]{5.0f, 5.0f}, 0.0f);
                    }
                    surfaceShape.setTextureSize(new Dimension(this.currentTextureWidth, this.currentTextureHeight));
                    surfaceShape.setStroke(basicStroke);
                    surfaceShape.setDrawBorder(true);
                } else {
                    ((SurfaceShape)this.currentShape).setDrawBorder(false);
                }
                if (!this.currentInteriorStyle.equals("None")) {
                    float f = this.currentInteriorOpacity >= 10 ? 1.0f : (this.currentInteriorOpacity <= 0 ? 0.0f : (float)this.currentInteriorOpacity / 10.0f);
                    color = null;
                    if (this.currentInteriorColor.equals("Yellow")) {
                        color = new Color(1.0f, 1.0f, 0.0f, f);
                    } else if (this.currentInteriorColor.equals("Red")) {
                        color = new Color(1.0f, 0.0f, 0.0f, f);
                    } else if (this.currentInteriorColor.equals("Green")) {
                        color = new Color(0.0f, 1.0f, 0.0f, f);
                    } else if (this.currentInteriorColor.equals("Blue")) {
                        color = new Color(0.0f, 0.0f, 1.0f, f);
                    }
                    surfaceShape.setPaint(color);
                    surfaceShape.setDrawInterior(true);
                } else {
                    surfaceShape.setDrawInterior(false);
                }
            } else {
                Serializable serializable;
                float f = this.currentPathOpacity >= 10 ? 1.0f : (this.currentPathOpacity <= 0 ? 0.0f : (float)this.currentPathOpacity / 10.0f);
                serializable = null;
                if (this.currentPathColor.equals("Yellow")) {
                    serializable = new Color(1.0f, 1.0f, 0.0f, f);
                } else if (this.currentPathColor.equals("Red")) {
                    serializable = new Color(1.0f, 0.0f, 0.0f, f);
                } else if (this.currentPathColor.equals("Green")) {
                    serializable = new Color(0.0f, 1.0f, 0.0f, f);
                } else if (this.currentPathColor.equals("Blue")) {
                    serializable = new Color(0.0f, 0.0f, 1.0f, f);
                }
                if (this.currentShape instanceof Polyline) {
                    Polyline polyline = (Polyline)this.currentShape;
                    polyline.setColor((Color)serializable);
                    polyline.setLineWidth(this.currentPathWidth);
                    polyline.setFollowTerrain(this.currentFollowTerrain);
                    polyline.setTerrainConformance(this.currentTerrainConformance);
                    polyline.setNumSubsegments(this.currentNumSubsegments);
                    if (this.currentPathType.equalsIgnoreCase("linear")) {
                        polyline.setPathType(1);
                    } else if (this.currentPathType.equalsIgnoreCase("rhumb line")) {
                        polyline.setPathType(2);
                    } else {
                        polyline.setPathType(0);
                    }
                    polyline.setOffset(this.currentOffset);
                    if (this.currentPathStyle.equals("Dash")) {
                        polyline.setStippleFactor(5);
                        polyline.setStipplePattern((short)-21846);
                    } else {
                        polyline.setStippleFactor(0);
                    }
                }
            }
            this.layer.removeAllRenderables();
            if (this.currentShape != null) {
                this.layer.addRenderable(this.currentShape);
            }
            this.wwjPanel.getWwd().redraw();
        }

        private Info[] buildSurfaceShapes() {
            LatLon latLon = new LatLon(Angle.fromDegrees(38.0), Angle.fromDegrees(-105.0));
            Globe globe = this.wwjPanel.getWwd().getModel().getGlobe();
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(latLon);
            arrayList.add(LatLon.fromDegrees(39.0, -104.0));
            arrayList.add(LatLon.fromDegrees(39.0, -105.0));
            arrayList.add(latLon);
            return new Info[]{new Info("Circle", new SurfaceCircle(globe, latLon, 100000.0, 30)), new Info("Ellipse", new SurfaceEllipse(globe, latLon, 100000.0, 90000.0, Angle.ZERO, 30)), new Info("Square", new SurfaceSquare(globe, latLon, 100000.0)), new Info("Quad", new SurfaceQuad(globe, latLon, 100000.0, 60000.0, Angle.ZERO)), new Info("Sector", new SurfaceSector(Sector.fromDegrees(38.0, 40.0, -105.0, -103.0))), new Info("Polygon", new SurfacePolygon(arrayList))};
        }

        private Info[] buildFreeShapes() {
            double d = 10000.0;
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(new Position(Angle.fromDegrees(37.8484), Angle.fromDegrees(-119.9754), d));
            arrayList.add(new Position(Angle.fromDegrees(39.354), Angle.fromDegrees(-110.1526), d));
            arrayList.add(new Position(Angle.fromDegrees(38.354), Angle.fromDegrees(-100.1526), d));
            ArrayList<Position> arrayList2 = new ArrayList<Position>();
            arrayList2.add(new Position(Angle.fromDegrees(0.0), Angle.fromDegrees(-150.0), d));
            arrayList2.add(new Position(Angle.fromDegrees(25.0), Angle.fromDegrees(-75.0), d));
            arrayList2.add(new Position(Angle.fromDegrees(50.0), Angle.fromDegrees(0.0), d));
            ArrayList<Position> arrayList3 = new ArrayList<Position>();
            double d2 = 42.0;
            double d3 = -100.0;
            while (d2 <= 45.0) {
                arrayList3.add(new Position(Angle.fromDegrees(d2), Angle.fromDegrees(d3), d));
                d2 += 0.1;
                d3 += 0.1;
            }
            ArrayList<Position> arrayList4 = new ArrayList<Position>();
            arrayList4.add(new Position(Angle.fromDegrees(90.0), Angle.fromDegrees(-110.0), d));
            arrayList4.add(new Position(Angle.fromDegrees(-90.0), Angle.fromDegrees(-110.0), d));
            ArrayList<Position> arrayList5 = new ArrayList<Position>();
            for (int i = 0; i < 100; ++i) {
                arrayList5.add(Position.fromDegrees(38.0 + (double)i * 1.0E-4, 30.0 + (double)i * 1.0E-4, 1000.0 + (double)i * 5.0));
            }
            Info[] infoArray = new Info[]{new Info("Short Path", new Polyline(arrayList)), new Info("Long Path", new Polyline(arrayList2)), new Info("Incremental Path", new Polyline(arrayList3)), new Info("Vertical Path", new Polyline(arrayList4)), new Info("Small-segment Path", new Polyline(arrayList5)), new Info("Quad", new Quadrilateral(Sector.fromDegrees(38.0, 40.0, -104.0, -105.0), d)), new Info("None", null)};
            return infoArray;
        }

        private JPanel makeShapeSelectionPanel() {
            Info[] infoArray = this.buildSurfaceShapes();
            GridLayout gridLayout = new GridLayout(infoArray.length, 1);
            JPanel jPanel = new JPanel(gridLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final Info info : infoArray) {
                JRadioButton jRadioButton = new JRadioButton(info.name);
                jRadioButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AppFrame.this.currentShape = (Renderable)info.object;
                        AppFrame.this.update();
                    }
                });
                buttonGroup.add(jRadioButton);
                jPanel.add(jRadioButton);
                if (!info.name.equalsIgnoreCase("none")) continue;
                jRadioButton.setSelected(true);
            }
            jPanel.setBorder(this.createTitleBorder("Surface Shapes"));
            Info[] infoArray2 = this.buildFreeShapes();
            gridLayout = new GridLayout(infoArray2.length, 1);
            JPanel jPanel2 = new JPanel(gridLayout);
            for (final Info info : infoArray2) {
                JRadioButton jRadioButton = new JRadioButton(info.name);
                jRadioButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AppFrame.this.currentShape = (Renderable)info.object;
                        AppFrame.this.update();
                    }
                });
                buttonGroup.add(jRadioButton);
                jPanel2.add(jRadioButton);
                if (!info.name.equalsIgnoreCase("none")) continue;
                jRadioButton.setSelected(true);
            }
            jPanel2.setBorder(this.createTitleBorder("Path Shapes"));
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 8, 1));
            jPanel3.add(jPanel2);
            jPanel3.add(jPanel);
            return jPanel3;
        }

        private Border createTitleBorder(String string) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
            return new CompoundBorder(titledBorder, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        private JPanel makeAttributesPanel() {
            JPanel jPanel = new JPanel(new GridLayout(1, 2, 8, 8));
            jPanel.add(this.makePathAttributesPanel());
            jPanel.add(this.makeInteriorAttributesPanel());
            return jPanel;
        }

        private JPanel makePathAttributesPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(6, 6));
            jPanel.setBorder(this.createTitleBorder("Path Attributes"));
            GridLayout gridLayout = new GridLayout(0, 1, 6, 6);
            JPanel jPanel2 = new JPanel(gridLayout);
            GridLayout gridLayout2 = new GridLayout(0, 1, 6, 6);
            JPanel jPanel3 = new JPanel(gridLayout2);
            jPanel2.add(new JLabel("Follow Terrain"));
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(this.currentFollowTerrain);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentFollowTerrain = ((JCheckBox)actionEvent.getSource()).isSelected();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jCheckBox);
            JLabel jLabel = new JLabel("Conformance");
            jPanel2.add(jLabel);
            int[] nArray = new int[]{1, 2, 4, 8, 10, 15, 20, 30, 40, 50};
            Object[] objectArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = Integer.toString(nArray[i]) + " pixels";
            }
            JSpinner jSpinner = new JSpinner(new SpinnerListModel(objectArray));
            this.onTerrainOnlyItems.add(jLabel);
            this.onTerrainOnlyItems.add(jSpinner);
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    String string = (String)((JSpinner)changeEvent.getSource()).getValue();
                    AppFrame.this.currentTerrainConformance = Integer.parseInt(string.substring(0, string.indexOf(" ")));
                    AppFrame.this.update();
                }
            });
            jSpinner.setValue(Integer.toString(this.currentTerrainConformance) + " pixels");
            jPanel3.add(jSpinner);
            jLabel = new JLabel("Subsegments");
            jPanel2.add(jLabel);
            jSpinner = new JSpinner(new SpinnerListModel(new String[]{"1", "2", "5", "10", "20", "40", "50"}));
            this.offTerrainOnlyItems.add(jLabel);
            this.offTerrainOnlyItems.add(jSpinner);
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    String string = (String)((JSpinner)changeEvent.getSource()).getValue();
                    AppFrame.this.currentNumSubsegments = Integer.parseInt(string);
                    AppFrame.this.update();
                }
            });
            jSpinner.setValue(Integer.toString(this.currentNumSubsegments));
            jPanel3.add(jSpinner);
            jPanel2.add(new JLabel("Type"));
            final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"Great Circle", "Linear", "Rhumb Line"});
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentPathType = (String)jComboBox.getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jComboBox.setSelectedItem("Great Circle");
            jPanel3.add(jComboBox);
            jPanel2.add(new JLabel("Style"));
            final JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{"None", "Solid", "Dash"});
            jComboBox2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentPathStyle = (String)jComboBox2.getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jComboBox2.setSelectedItem("Solid");
            jPanel3.add(jComboBox2);
            jPanel2.add(new JLabel("Width"));
            jSpinner = new JSpinner(new SpinnerListModel(new String[]{"1.0", "1.25", "1.5", "2.0", "3.0", "4.0", "5.0", "10.0"}));
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.currentPathWidth = Float.parseFloat((String)((JSpinner)changeEvent.getSource()).getValue());
                    AppFrame.this.update();
                }
            });
            jSpinner.setValue(Float.toString(this.currentPathWidth));
            jPanel3.add(jSpinner);
            jPanel2.add(new JLabel("Color"));
            JComboBox<String> jComboBox3 = new JComboBox<String>(new String[]{"Red", "Green", "Blue", "Yellow"});
            jComboBox3.setSelectedItem(this.currentPathColor);
            jComboBox3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentPathColor = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jComboBox3);
            jPanel2.add(new JLabel("Opacity"));
            jSpinner = new JSpinner(new SpinnerNumberModel(this.currentPathOpacity, 0, 10, 1));
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.currentPathOpacity = (Integer)((JSpinner)changeEvent.getSource()).getValue();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jSpinner);
            jPanel2.add(new JLabel("Offset"));
            jSpinner = new JSpinner(new SpinnerListModel(new String[]{"0", "10", "100", "1000", "10000", "100000", "1000000"}));
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.currentOffset = Float.parseFloat((String)((JSpinner)changeEvent.getSource()).getValue());
                    AppFrame.this.update();
                }
            });
            jSpinner.setValue("0");
            jPanel3.add(jSpinner);
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
            return jPanel;
        }

        private JPanel makeInteriorAttributesPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(6, 6));
            jPanel.setBorder(this.createTitleBorder("Surface Attributes"));
            GridLayout gridLayout = new GridLayout(0, 1, 6, 6);
            JPanel jPanel2 = new JPanel(gridLayout);
            GridLayout gridLayout2 = new GridLayout(0, 1, 6, 6);
            JPanel jPanel3 = new JPanel(gridLayout2);
            jPanel2.add(new JLabel("Style"));
            final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"None", "Solid", "Texture", "Image"});
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentInteriorStyle = (String)jComboBox.getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jComboBox.setSelectedItem("Solid");
            jPanel3.add(jComboBox);
            jPanel2.add(new JLabel("Opacity"));
            JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.currentBorderOpacity, 0, 10, 1));
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.currentInteriorOpacity = (Integer)((JSpinner)changeEvent.getSource()).getValue();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jSpinner);
            jPanel2.add(new JLabel("Color"));
            JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{"Red", "Green", "Blue", "Yellow"});
            jComboBox2.setSelectedItem(this.currentInteriorColor);
            jComboBox2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentInteriorColor = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jComboBox2);
            JLabel jLabel = new JLabel("Image");
            jLabel.setEnabled(false);
            jPanel2.add(jLabel);
            JComboBox<String> jComboBox3 = new JComboBox<String>(new String[]{"Meatball", "WW Splash", "RSS Feed"});
            jComboBox3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentInteriorStyle = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jComboBox3.setEnabled(false);
            jPanel3.add(jComboBox3);
            jPanel2.add(new JLabel("Texture Width"));
            JComboBox<String> jComboBox4 = new JComboBox<String>(new String[]{"16", "32", "64", "128", "256", "512", "1024", "2048"});
            jComboBox4.setSelectedItem(Integer.toString(this.currentTextureWidth));
            jComboBox4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentTextureWidth = Integer.parseInt((String)((JComboBox)actionEvent.getSource()).getSelectedItem());
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jComboBox4);
            jPanel2.add(new JLabel("Texture Height"));
            jComboBox4 = new JComboBox<String>(new String[]{"16", "32", "64", "128", "256", "512", "1024", "2048"});
            jComboBox4.setSelectedItem(Integer.toString(this.currentTextureHeight));
            jComboBox4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentTextureHeight = Integer.parseInt((String)((JComboBox)actionEvent.getSource()).getSelectedItem());
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jComboBox4);
            jPanel2.add(new JLabel("Border"));
            final JComboBox<String> jComboBox5 = new JComboBox<String>(new String[]{"None", "Solid", "Dash"});
            jComboBox5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentBorderStyle = (String)jComboBox5.getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jComboBox5.setSelectedItem("Solid");
            jPanel3.add(jComboBox5);
            jPanel2.add(new JLabel("Border Width"));
            jSpinner = new JSpinner(new SpinnerListModel(new String[]{"1.0", "1.25", "1.5", "2.0", "3.0", "4.0", "5.0", "10.0"}));
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.currentBorderWidth = Float.parseFloat((String)((JSpinner)changeEvent.getSource()).getValue());
                    AppFrame.this.update();
                }
            });
            jSpinner.setValue(Float.toString(this.currentBorderWidth));
            jPanel3.add(jSpinner);
            jPanel2.add(new JLabel("Border Color"));
            JComboBox<String> jComboBox6 = new JComboBox<String>(new String[]{"Red", "Green", "Blue", "Yellow"});
            jComboBox6.setSelectedItem(this.currentBorderColor);
            jComboBox6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.currentBorderColor = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jComboBox6);
            jPanel2.add(new JLabel("Border Opacity"));
            jSpinner = new JSpinner(new SpinnerNumberModel(this.currentBorderOpacity, 0, 10, 1));
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.currentBorderOpacity = (Integer)((JSpinner)changeEvent.getSource()).getValue();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(jSpinner);
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
            return jPanel;
        }

        private void setupSelection() {
            this.wwjPanel.getWwd().addSelectListener(new SelectListener(){
                private WWIcon lastToolTipIcon = null;
                private BasicDragger dragger = new BasicDragger(AppFrame.access$100(AppFrame.this).getWwd());

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover")) {
                        if (this.lastToolTipIcon != null) {
                            this.lastToolTipIcon.setShowToolTip(false);
                            this.lastToolTipIcon = null;
                            AppFrame.this.wwjPanel.getWwd().repaint();
                        }
                        if (selectEvent.hasObjects() && !this.dragger.isDragging() && selectEvent.getTopObject() instanceof WWIcon) {
                            this.lastToolTipIcon = (WWIcon)selectEvent.getTopObject();
                            this.lastToolTipIcon.setShowToolTip(true);
                            AppFrame.this.wwjPanel.getWwd().repaint();
                        }
                    } else if ((!selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") || this.dragger.isDragging()) && (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag"))) {
                        PickedObjectList pickedObjectList;
                        this.dragger.selected(selectEvent);
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AppFrame.this.wwjPanel.getWwd().getObjectsAtCurrentPosition()) != null) {
                            AppFrame.this.wwjPanel.getWwd().redraw();
                        }
                    }
                }
            });
        }
    }

    private static class Info {
        private final Object object;
        private final String name;

        public Info(String string, Object object) {
            this.object = object;
            this.name = string;
        }
    }
}

