/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Gazetteer;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class GazetteerPanel
extends JPanel {
    private final WorldWindow wwd;
    private Gazetteer gazeteer = new Gazetteer();

    public GazetteerPanel(WorldWindow worldWindow) {
        super(new BorderLayout());
        this.wwd = worldWindow;
        URL uRL = this.getClass().getResource("/images/safari-32x32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        final JTextField jTextField = new JTextField("Where to go?");
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(final ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        String string = jTextField.getText();
                        if (string != null && string.equals("show wms")) {
                            return;
                        }
                        try {
                            GazetteerPanel.this.handleEntryAction(actionEvent);
                        }
                        catch (Gazetteer.GazetteerException gazetteerException) {
                            JOptionPane.showMessageDialog(GazetteerPanel.this, "Location not available (" + gazetteerException.getMessage() + ")", "Location Not Available", 0);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(GazetteerPanel.this, "Error looking up \"" + (jTextField.getText() != null ? jTextField.getText() : "") + "\"\n" + exception.getMessage(), "Lookup Failure", 0);
                        }
                    }
                });
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTextField, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 15));
        this.add((Component)jLabel, "West");
        this.add((Component)jPanel, "Center");
    }

    private void handleEntryAction(ActionEvent actionEvent) throws IOException, ParserConfigurationException, XPathExpressionException, SAXException, Gazetteer.GazetteerException {
        String string = null;
        if (actionEvent.getSource() instanceof JTextComponent) {
            string = ((JTextComponent)actionEvent.getSource()).getText();
        }
        if (string == null || string.length() < 1) {
            return;
        }
        ArrayList<Gazetteer.Location> arrayList = this.gazeteer.getLocations(string);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        this.moveToLocation(arrayList.get(0));
    }

    private void moveToLocation(Gazetteer.Location location) {
        System.out.println("Orbiting");
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        if (globe != null && orbitView != null) {
            orbitView.applyStateIterator(FlyToOrbitViewStateIterator.createPanToIterator(orbitView, globe, new Position(location.getLatlon(), 0.0), Angle.ZERO, Angle.ZERO, 25000.0));
        }
    }
}

