/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.AbstractSceneController;
import gov.nasa.worldwind.BasicSceneController;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.ClickAndGoSelectListener;
import gov.nasa.worldwind.examples.FlatWorldPanel;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.view.FlatOrbitView;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FlatWorldEarthquakes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", 0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 5.0E7);
        Configuration.setValue("gov.nasa.worldwind.avkey.GlobeClassName", EarthFlat.class.getName());
        Configuration.setValue("gov.nasa.worldwind.avkey.ViewClassName", FlatOrbitView.class.getName());
        ApplicationTemplate.start("World Wind USGS Earthquakes M 2.5+ - 7 days", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private RenderableLayer eqLayer;
        private EqAnnotation mouseEq;
        private EqAnnotation latestEq;
        private GlobeAnnotation tooltipAnnotation;
        private JButton downloadButton;
        private JLabel statusLabel;
        private JLabel latestLabel;
        private Date lastUpdate;
        private Blinker blinker;
        private Timer updater;
        private Date lastUpdaterEvent;
        private JComboBox magnitudeCombo;
        private AnnotationAttributes eqAttributes;
        private BufferedImage[] eqIcons = new BufferedImage[]{PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, Color.RED), PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, Color.ORANGE), PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, Color.YELLOW), PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, Color.GREEN), PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, Color.BLUE), PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, Color.GRAY), PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, Color.BLACK)};
        private Color[] eqColors = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.GRAY, Color.BLACK};

        public AppFrame() {
            super(true, true, false);
            Object object;
            LayerList layerList = this.getWwd().getModel().getLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                if (layerList.get(i) instanceof SkyGradientLayer) {
                    layerList.set(i, new SkyColorLayer());
                    continue;
                }
                if (layerList.get(i) instanceof WorldMapLayer) {
                    ((WorldMapLayer)layerList.get(i)).setMaxActiveAltitude(2.0E7);
                    continue;
                }
                if (!(layerList.get(i) instanceof CompassLayer)) continue;
                ((CompassLayer)layerList.get(i)).setMaxActiveAltitude(2.0E7);
            }
            this.tooltipAnnotation = new GlobeAnnotation("", Position.fromDegrees(0.0, 0.0, 0.0));
            Font font = Font.decode("Arial-Plain-16");
            this.tooltipAnnotation.getAttributes().setFont(font);
            this.tooltipAnnotation.getAttributes().setTextColor(Color.BLACK);
            this.tooltipAnnotation.getAttributes().setBorderColor(Color.BLACK);
            this.tooltipAnnotation.getAttributes().setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
            this.tooltipAnnotation.getAttributes().setSize(new Dimension(270, 0));
            this.tooltipAnnotation.getAttributes().setDistanceMinScale(1.0);
            this.tooltipAnnotation.getAttributes().setDistanceMaxScale(1.0);
            this.tooltipAnnotation.getAttributes().setVisible(false);
            this.tooltipAnnotation.setAlwaysOnTop(true);
            SceneController sceneController = this.getWwd().getSceneController();
            if (sceneController != null && sceneController instanceof BasicSceneController) {
                object = (BasicSceneController)sceneController;
                TextRenderer textRenderer = new TextRenderer(font, false, false);
                textRenderer.setUseVertexArrays(false);
                ((AbstractSceneController)object).getTextRendererCache().add(font, textRenderer);
            }
            object = new JPanel();
            ((Container)object).setLayout(new BoxLayout((Container)object, 1));
            ((Container)object).add(this.makeEarthquakesPanel());
            ((Container)object).add(new FlatWorldPanel(this.getWwd()));
            this.getLayerPanel().add((Component)object, "South");
            this.getWwd().addSelectListener(new SelectListener(){

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    }
                }
            });
            this.getWwd().addSelectListener(new ClickAndGoSelectListener(this.getWwd(), EqAnnotation.class, 1000000.0));
            this.updater = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.lastUpdaterEvent == null) {
                        AppFrame.this.lastUpdaterEvent = new Date();
                    }
                    Date date = new Date();
                    long l = 300000L;
                    long l2 = date.getTime() - AppFrame.this.lastUpdaterEvent.getTime();
                    if (l2 >= l) {
                        AppFrame.this.lastUpdaterEvent = new Date();
                        AppFrame.this.downloadButton.setText("Update");
                        AppFrame.this.startEarthquakeDownload();
                    } else {
                        long l3 = l - l2;
                        int n = (int)Math.floor((double)l3 / 60000.0);
                        int n2 = (int)((l3 - (long)n * 60000L) / 1000L);
                        AppFrame.this.downloadButton.setText(String.format("Update (in %1$02d:%2$02d)", n, n2));
                    }
                }
            });
            this.updater.start();
            this.startEarthquakeDownload();
        }

        private void highlight(Object object) {
            if (this.mouseEq == object) {
                return;
            }
            if (this.mouseEq != null) {
                this.mouseEq.getAttributes().setHighlighted(false);
                this.mouseEq = null;
                this.tooltipAnnotation.getAttributes().setVisible(false);
            }
            if (object != null && object instanceof EqAnnotation) {
                this.mouseEq = (EqAnnotation)object;
                this.mouseEq.getAttributes().setHighlighted(true);
                this.tooltipAnnotation.setText("<p><b>" + this.mouseEq.earthquake.title + "</b></p>" + this.composeElapsedString(this.mouseEq) + "<br />" + this.mouseEq.earthquake.summary);
                this.tooltipAnnotation.setPosition(this.mouseEq.earthquake.position);
                this.tooltipAnnotation.getAttributes().setVisible(true);
                this.getWwd().repaint();
            }
        }

        private void setBlinker(EqAnnotation eqAnnotation) {
            if (this.blinker != null) {
                this.blinker.stop();
                this.getWwd().repaint();
            }
            if (eqAnnotation == null) {
                return;
            }
            this.blinker = new Blinker(eqAnnotation);
        }

        private void setLatestLabel(EqAnnotation eqAnnotation) {
            this.latestLabel.setText("");
            if (eqAnnotation != null) {
                String string = "<html>" + this.composeElapsedString(eqAnnotation) + "<p><b>" + eqAnnotation.earthquake.title + "</b></p>" + eqAnnotation.earthquake.summary + "</html>";
                string = string.replaceAll("(?i)<img\\s?.*?>", "\n");
                this.latestLabel.setText(string);
            }
        }

        private String composeElapsedString(EqAnnotation eqAnnotation) {
            String string = "";
            if (eqAnnotation.earthquake.date != null) {
                Date date = new Date();
                long l = date.getTime() - eqAnnotation.earthquake.date.getTime();
                long l2 = l / 86400000L;
                long l3 = (l -= l2 * 86400000L) / 3600000L;
                long l4 = (l -= l3 * 3600000L) / 60000L;
                string = l2 > 0L ? l2 + (l2 > 1L ? " days" : " day") + (l3 > 0L ? " and " + l3 + (l3 > 1L ? " hours" : " hour") : "") : (l3 > 0L ? l3 + (l3 > 1L ? " hours" : " hour") + (l3 < 12L ? " and " + l4 + (l4 > 1L ? " minutes" : " minute") : "") : l4 + (l4 > 1L ? " minutes" : " minute"));
                string = string + " ago";
            }
            return string;
        }

        private JPanel makeEarthquakesPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton jButton = new JButton("Zoom on latest");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.latestEq != null) {
                        Position position = ((AppFrame)AppFrame.this).latestEq.earthquake.position;
                        OrbitView orbitView = (OrbitView)AppFrame.this.getWwd().getView();
                        Globe globe = AppFrame.this.getWwd().getModel().getGlobe();
                        orbitView.applyStateIterator(FlyToOrbitViewStateIterator.createPanToIterator(orbitView, globe, new Position(position.getLatLon(), 0.0), Angle.ZERO, Angle.ZERO, 1000000.0));
                    }
                }
            });
            jPanel2.add(jButton);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton jButton2 = new JButton("Reset Global View");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Double d = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLatitude");
                    Double d2 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLongitude");
                    Double d3 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialAltitude");
                    Position position = Position.fromDegrees(d, d2, 0.0);
                    OrbitView orbitView = (OrbitView)AppFrame.this.getWwd().getView();
                    Globe globe = AppFrame.this.getWwd().getModel().getGlobe();
                    orbitView.applyStateIterator(FlyToOrbitViewStateIterator.createPanToIterator(orbitView, globe, new Position(position.getLatLon(), 0.0), Angle.ZERO, Angle.ZERO, d3));
                }
            });
            jPanel3.add(jButton2);
            jPanel.add(jPanel3);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.downloadButton = new JButton("Update");
            this.downloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.startEarthquakeDownload();
                }
            });
            this.downloadButton.setEnabled(false);
            jPanel4.add(this.downloadButton);
            jPanel.add(jPanel4);
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.statusLabel = new JLabel();
            this.statusLabel.setPreferredSize(new Dimension(200, 20));
            this.statusLabel.setVerticalAlignment(0);
            jPanel5.add(this.statusLabel);
            jPanel.add(jPanel5);
            JPanel jPanel6 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel6.add(new JLabel("Min Magnitude:"));
            this.magnitudeCombo = new JComboBox<String>(new String[]{"2.5", "3", "4", "5", "6", "7"});
            this.magnitudeCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.applyFilter(Double.parseDouble((String)AppFrame.this.magnitudeCombo.getSelectedItem()));
                }
            });
            jPanel6.add(this.magnitudeCombo);
            jPanel.add(jPanel6);
            JPanel jPanel7 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel7.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel7.add(new JLabel("Latest:"));
            final JCheckBox jCheckBox = new JCheckBox("Animate");
            jCheckBox.setSelected(true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCheckBox.isSelected()) {
                        AppFrame.this.setBlinker(AppFrame.this.latestEq);
                    } else {
                        AppFrame.this.setBlinker(null);
                    }
                }
            });
            jPanel7.add(jCheckBox);
            jPanel.add(jPanel7);
            JPanel jPanel8 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel8.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.latestLabel = new JLabel();
            this.latestLabel.setPreferredSize(new Dimension(200, 140));
            this.latestLabel.setVerticalAlignment(1);
            jPanel8.add(this.latestLabel);
            jPanel.add(jPanel8);
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Earthquakes")));
            jPanel.setToolTipText("Earthquakes controls.");
            return jPanel;
        }

        private void startEarthquakeDownload() {
            new Thread(new Runnable(){

                public void run() {
                    AppFrame.this.downloadEarthquakes();
                }
            }, "Earthquakes download").start();
        }

        private void downloadEarthquakes() {
            if (this.downloadButton != null) {
                this.downloadButton.setEnabled(false);
            }
            if (this.statusLabel != null) {
                this.statusLabel.setText("Downloading earthquakes...");
            }
            this.lastUpdaterEvent = new Date();
            RenderableLayer renderableLayer = (RenderableLayer)this.buildEarthquakeLayer();
            if (renderableLayer.getRenderables().iterator().hasNext()) {
                LayerList layerList = this.getWwd().getModel().getLayers();
                if (this.eqLayer != null) {
                    layerList.remove(this.eqLayer);
                }
                this.eqLayer = renderableLayer;
                this.eqLayer.addRenderable(this.tooltipAnnotation);
                ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.eqLayer);
                this.getLayerPanel().update(this.getWwd());
                this.lastUpdate = new Date();
                if (this.statusLabel != null) {
                    this.statusLabel.setText(this.lastUpdate.toString());
                }
                this.applyFilter(Double.parseDouble((String)this.magnitudeCombo.getSelectedItem()));
            } else if (this.statusLabel != null) {
                this.statusLabel.setText("Download failed!");
            }
            if (this.downloadButton != null) {
                this.downloadButton.setEnabled(true);
            }
        }

        private Layer buildEarthquakeLayer() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Earthquakes");
            try {
                URL uRL = new URL("http://earthquake.usgs.gov/eqcenter/catalogs/7day-M2.5.xml");
                ByteBuffer byteBuffer = WWIO.readURLContentToBuffer(uRL);
                this.parseFile(renderableLayer, WWIO.saveBufferToTempFile(byteBuffer, ".xml"));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return renderableLayer;
        }

        private void parseFile(RenderableLayer renderableLayer, File file) {
            if (file == null) {
                String string = Logging.getMessage("nullValue.FileIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                this.parseDoc(renderableLayer, document);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                String string = Logging.getMessage("GeoRSS.ParserConfigurationException");
                Logging.logger().log(Level.SEVERE, string, parserConfigurationException);
                throw new WWRuntimeException(string, parserConfigurationException);
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("GeoRSS.IOExceptionParsing", file.getPath());
                Logging.logger().log(Level.SEVERE, string, iOException);
                throw new WWRuntimeException(string, iOException);
            }
            catch (SAXException sAXException) {
                String string = Logging.getMessage("GeoRSS.IOExceptionParsing", file.getPath());
                Logging.logger().log(Level.SEVERE, string, sAXException);
                throw new WWRuntimeException(string, sAXException);
            }
        }

        private void parseDoc(RenderableLayer renderableLayer, Document document) {
            if (document == null) {
                String string = Logging.getMessage("nullValue.DocumentIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            NodeList nodeList = document.getElementsByTagName("entry");
            if (nodeList != null && nodeList.getLength() > 0) {
                this.latestEq = null;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Earthquake earthquake = new Earthquake(node);
                    this.addEarthquake(renderableLayer, earthquake);
                }
            }
        }

        private void addEarthquake(RenderableLayer renderableLayer, Earthquake earthquake) {
            if (this.eqAttributes == null) {
                this.eqAttributes = new AnnotationAttributes();
                this.eqAttributes.setLeader("Render.FrameFactory.LeaderNone");
                this.eqAttributes.setDrawOffset(new Point(0, -16));
                this.eqAttributes.setSize(new Dimension(32, 32));
                this.eqAttributes.setBorderWidth(0.0);
                this.eqAttributes.setCornerRadius(0);
                this.eqAttributes.setBackgroundColor(new Color(0, 0, 0, 0));
            }
            EqAnnotation eqAnnotation = new EqAnnotation(earthquake, this.eqAttributes);
            int n = 6;
            if (earthquake.date != null) {
                Date date = new Date();
                n = (int)((date.getTime() - earthquake.date.getTime()) / 86400000L);
                if (this.latestEq != null) {
                    if (this.latestEq.earthquake.date.getTime() < earthquake.date.getTime()) {
                        this.latestEq = eqAnnotation;
                    }
                } else {
                    this.latestEq = eqAnnotation;
                }
            }
            eqAnnotation.getAttributes().setImageSource(this.eqIcons[Math.min(n, this.eqIcons.length - 1)]);
            eqAnnotation.getAttributes().setTextColor(this.eqColors[Math.min(n, this.eqColors.length - 1)]);
            eqAnnotation.getAttributes().setScale(earthquake.magnitude / 10.0);
            renderableLayer.addRenderable(eqAnnotation);
        }

        private static Node findChildByName(Node node, String string) {
            NodeList nodeList = node.getChildNodes();
            if (nodeList == null || nodeList.getLength() < 1) {
                return null;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2 = nodeList.item(i).getNodeName();
                if (string2 == null || !string2.equals(string)) continue;
                return nodeList.item(i);
            }
            return null;
        }

        private void applyFilter(double d) {
            this.latestEq = null;
            this.setBlinker(null);
            this.setLatestLabel(null);
            Iterable<Renderable> iterable = this.eqLayer.getRenderables();
            for (Renderable renderable : iterable) {
                if (!(renderable instanceof EqAnnotation)) continue;
                EqAnnotation eqAnnotation = (EqAnnotation)renderable;
                eqAnnotation.getAttributes().setVisible(eqAnnotation.earthquake.magnitude >= d);
                if (!eqAnnotation.getAttributes().isVisible()) continue;
                if (this.latestEq != null) {
                    if (this.latestEq.earthquake.date == null || eqAnnotation.earthquake.date == null || this.latestEq.earthquake.date.getTime() >= eqAnnotation.earthquake.date.getTime()) continue;
                    this.latestEq = eqAnnotation;
                    continue;
                }
                this.latestEq = eqAnnotation;
            }
            this.setBlinker(this.latestEq);
            this.setLatestLabel(this.latestEq);
            this.getWwd().repaint();
        }

        private class Blinker {
            private EqAnnotation annotation;
            private double initialScale;
            private double initialOpacity;
            private int steps = 10;
            private int step = 0;
            private int delay = 100;
            private Timer timer;

            private Blinker(EqAnnotation eqAnnotation) {
                this.annotation = eqAnnotation;
                this.initialScale = this.annotation.getAttributes().getScale();
                this.initialOpacity = this.annotation.getAttributes().getOpacity();
                this.timer = new Timer(this.delay, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Blinker.this.annotation.getAttributes().setScale(Blinker.this.initialScale * (double)(1.0f + 7.0f * ((float)Blinker.this.step / (float)Blinker.this.steps)));
                        Blinker.this.annotation.getAttributes().setOpacity(Blinker.this.initialOpacity * (double)(1.0f - (float)Blinker.this.step / (float)Blinker.this.steps));
                        Blinker.this.step = Blinker.this.step == Blinker.this.steps ? 0 : Blinker.this.step + 1;
                        AppFrame.this.getWwd().repaint();
                    }
                });
                this.start();
            }

            private void stop() {
                this.timer.stop();
                this.step = 0;
                this.annotation.getAttributes().setScale(this.initialScale);
                this.annotation.getAttributes().setOpacity(this.initialOpacity);
            }

            private void start() {
                this.timer.start();
            }
        }

        private class EqAnnotation
        extends GlobeAnnotation {
            public Earthquake earthquake;
            private DoubleBuffer shapeBuffer;

            public EqAnnotation(Earthquake earthquake, AnnotationAttributes annotationAttributes) {
                super("", earthquake.position, annotationAttributes);
                this.earthquake = earthquake;
            }

            public void drawAnnotation(DrawContext drawContext, Point point, double d, double d2, Position position) {
                this.scaleFactor = this.attributes.getScale() * d;
                this.alphaFactor = this.attributes.getOpacity() * d2 * 0.6;
                if (this.attributes.isHighlighted()) {
                    this.scaleFactor *= this.attributes.getHighlightScale();
                    this.alphaFactor = 1.0;
                }
                drawContext.getGL().glScaled(this.scaleFactor, this.scaleFactor, 1.0);
                if (drawContext.isPickingMode()) {
                    Color color = drawContext.getUniquePickColor();
                    int n = color.getRGB();
                    this.getPickSupport().addPickableObject(n, this.delegateOwner != null ? this.delegateOwner : this, position, false);
                    drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                } else {
                    Color color = this.getAttributes().getTextColor();
                    this.setDrawColor(drawContext, new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * this.alphaFactor)));
                }
                if (this.shapeBuffer == null) {
                    this.shapeBuffer = FrameFactory.createShapeBuffer("Render.FrameFactory.ShapeEllipse", 32.0, 32.0, 0);
                }
                drawContext.getGL().glTranslated(-16.0, -16.0, 0.0);
                FrameFactory.drawBuffer(drawContext, 6, this.shapeBuffer);
            }
        }

        private class Earthquake {
            public String title;
            public String summary;
            public Position position;
            public double elevation;
            public Date date;
            public double magnitude;
            public String link;

            public Earthquake(Node node) {
                Object object;
                Node node2 = AppFrame.findChildByName(node, "title");
                if (node2 != null) {
                    this.title = node2.getTextContent();
                    this.magnitude = Double.parseDouble(this.title.split(",")[0].substring(2));
                }
                if ((node2 = AppFrame.findChildByName(node, "georss:point")) != null) {
                    object = node2.getTextContent();
                    String[] stringArray = ((String)object).split(" ");
                    this.position = Position.fromDegrees(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), 0.0);
                }
                if ((node2 = AppFrame.findChildByName(node, "georss:elev")) != null) {
                    this.elevation = Double.parseDouble(node2.getTextContent());
                }
                if ((node2 = AppFrame.findChildByName(node, "summary")) != null) {
                    this.summary = node2.getTextContent();
                }
                if ((node2 = AppFrame.findChildByName(node, "link")) != null) {
                    this.link = node2.getAttributes().getNamedItem("href").getTextContent();
                }
                if ((node2 = AppFrame.findChildByName(node, "updated")) != null) {
                    object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    ((DateFormat)object).setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    try {
                        this.date = ((DateFormat)object).parse(node2.getTextContent().replaceAll("[TZ]", " ").trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

