/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.cache.FileCache;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFileCache
implements FileCache {
    private final LinkedList<File> cacheDirs = new LinkedList();
    private File cacheWriteDir = null;

    protected void initialize(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            this.buildWritePaths(document);
            this.buildReadPaths(document);
            if (this.cacheWriteDir == null) {
                Logging.logger().warning("FileCache.NoFileCacheWriteLocation");
            }
            if (this.cacheDirs.size() == 0) {
                String string = Logging.getMessage("FileCache.NoFileCacheReadLocations");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = Logging.getMessage("FileCache.NoFileCacheReadLocations");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = Logging.getMessage("FileCache.NoFileCacheReadLocations");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("FileCache.ExceptionReadingCacheLocationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, iOException);
        }
    }

    @Override
    public void addCacheLocation(String string) {
        this.addCacheLocation(this.cacheDirs.size(), string);
    }

    @Override
    public void addCacheLocation(int n, String string) {
        File file;
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileCachePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n < 0) {
            String string3 = Logging.getMessage("generic.InvalidIndex", n);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        if (n > 0 && n > this.cacheDirs.size()) {
            n = this.cacheDirs.size();
        }
        if (this.cacheDirs.contains(file = new File(string))) {
            this.cacheDirs.remove(file);
        }
        this.cacheDirs.add(n, file);
    }

    @Override
    public void removeCacheLocation(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileCachePathIsNull");
            Logging.logger().severe(string2);
            return;
        }
        File file = new File(string);
        if (file.equals(this.cacheWriteDir)) {
            String string3 = Logging.getMessage("FileCache.CannotRemoveWriteLocationFromSearchList", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.cacheDirs.remove(new File(string));
    }

    @Override
    public List<File> getCacheLocations() {
        return new LinkedList<File>(this.cacheDirs);
    }

    @Override
    public File getWriteLocation() {
        return this.cacheWriteDir;
    }

    private void buildReadPaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileCache/readLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = AbstractFileCache.buildLocationPath(string, string3, string2);
                if (string4 == null) {
                    Logging.logger().log(Level.WARNING, "FileCache.CacheLocationInvalid", string != null ? string : Logging.getMessage("generic.Unknown"));
                    continue;
                }
                File file = new File(string4);
                if (file.exists() && !file.isDirectory()) {
                    Logging.logger().log(Level.WARNING, "FileCache.CacheLocationIsFile", file.getPath());
                }
                if (this.cacheDirs.contains(file)) continue;
                this.cacheDirs.add(file);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("FileCache.NoFileCacheReadLocations");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, xPathExpressionException);
        }
    }

    private void buildWritePaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileCache/writeLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = xPath.evaluate("@create", node2);
                String string5 = AbstractFileCache.buildLocationPath(string, string3, string2);
                if (string5 == null) {
                    Logging.logger().log(Level.WARNING, "FileCache.CacheLocationInvalid", string != null ? string : Logging.getMessage("generic.Unknown"));
                    continue;
                }
                Logging.logger().log(Level.FINER, "FileCache.AttemptingWriteCache", string5);
                File file = new File(string5);
                if (!file.exists() && string4 != null && (string4.contains("t") || string4.contains("T"))) {
                    Logging.logger().log(Level.FINER, "FileCache.MakingDirsFor", string5);
                    file.mkdirs();
                }
                if (!file.isDirectory() || !file.canWrite() || !file.canRead()) continue;
                Logging.logger().log(Level.FINER, "FileCache.WriteCacheSuccessful", string5);
                this.cacheWriteDir = file;
                this.cacheDirs.addFirst(file);
                break;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("FileCache.NoFileCacheReadLocations");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, xPathExpressionException);
        }
    }

    private static String buildLocationPath(String string, String string2, String string3) {
        String string4 = AbstractFileCache.propertyToPath(string);
        if (string2 != null && string2.length() != 0) {
            string4 = AbstractFileCache.appendPathPart(string4, string2.trim());
        }
        if (string3 != null && string3.length() != 0) {
            string4 = AbstractFileCache.appendPathPart(string4, string3.trim());
        }
        return string4;
    }

    private static String appendPathPart(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string2.length() == 0) {
            return string2;
        }
        string = AbstractFileCache.stripTrailingSeparator(string);
        string2 = AbstractFileCache.stripLeadingSeparator(string2);
        return string + System.getProperty("file.separator") + string2;
    }

    private static String stripTrailingSeparator(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String stripLeadingSeparator(String string) {
        if (string.startsWith("/") || string.startsWith("\\")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    private static String propertyToPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.alluser.cache")) {
            return AbstractFileCache.determineAllUserCacheDir();
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.user.cache")) {
            return AbstractFileCache.determineSingleUserCacheDir();
        }
        return null;
    }

    private static String determineAllUserCacheDir() {
        if (Configuration.isMacOS()) {
            return "/Library/Caches";
        }
        if (Configuration.isWindowsOS()) {
            String string = System.getenv("ALLUSERSPROFILE");
            if (string == null) {
                Logging.logger().severe("generic.AllUsersWindowsProfileNotKnown");
                return null;
            }
            return string + "\\Application Data";
        }
        if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            return "/var/cache/";
        }
        Logging.logger().warning("generic.UnknownOperatingSystem");
        return null;
    }

    private static String determineSingleUserCacheDir() {
        String string = AbstractFileCache.getUserHomeDir();
        if (string == null) {
            Logging.logger().warning("generic.UsersHomeDirectoryNotKnown");
            return null;
        }
        String string2 = null;
        if (Configuration.isMacOS()) {
            string2 = "/Library/Caches";
        } else if (Configuration.isWindowsOS()) {
            string2 = System.getenv("USERPROFILE");
            if (string2 == null) {
                Logging.logger().fine("generic.UsersWindowsProfileNotKnown");
                return null;
            }
            string2 = string2 + "\\Application Data";
        } else if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            string2 = "/var/cache/";
        } else {
            Logging.logger().fine("generic.UnknownOperatingSystem");
        }
        if (string2 == null) {
            return null;
        }
        return string + string2;
    }

    private static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    @Override
    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        for (File file : this.cacheDirs) {
            File file2 = string.startsWith(file.getAbsolutePath()) ? new File(string) : this.cachePathForFile(file, string);
            if (!file2.exists()) continue;
            return true;
        }
        return false;
    }

    private File cachePathForFile(File file, String string) {
        return new File(file.getAbsolutePath() + "/" + string);
    }

    private String makeFullPath(File file, String string) {
        return file.getAbsolutePath() + "/" + string;
    }

    @Override
    public File newFile(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.cacheWriteDir != null) {
            String string3 = this.makeFullPath(this.cacheWriteDir, string);
            File file = new File(string3);
            if (file.getParentFile().exists()) {
                return file;
            }
            if (file.getParentFile().mkdirs()) {
                return file;
            }
            String string4 = Logging.getMessage("generic.CantCreateCacheFile", string3);
            Logging.logger().severe(string4);
        }
        return null;
    }

    @Override
    public URL findFile(String string, boolean bl) {
        Object object;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (bl && (object = this.getClass().getClassLoader().getResource(string)) != null) {
            return object;
        }
        for (File file : this.cacheDirs) {
            File file2;
            if (!file.exists() || !(file2 = new File(this.makeFullPath(file, string))).exists()) continue;
            try {
                return file2.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("FileCache.ExceptionCreatingURLForFile", file2.getPath()), malformedURLException);
            }
        }
        return null;
    }

    @Override
    public void removeFile(URL uRL) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            File file = new File(uRL.toURI());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("FileCache.ExceptionRemovingFile", uRL.toString()), uRISyntaxException);
        }
    }
}

