/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;

class OrbitViewInputSupport
implements PropertyChangeListener {
    private OrbitView orbitView;
    private boolean viewChanged;
    private boolean viewOutOfFocus;
    private boolean targetStopped;
    private Position centerTarget;
    private Angle headingTarget;
    private Angle pitchTarget;
    private double zoomTarget = -1.0;
    private double centerMinEpsilon;
    private double headingMinEpsilon;
    private double pitchMinEpsilon;
    private double zoomMinEpsilon;
    private double centerSmoothing;
    private double headingSmoothing;
    private double pitchSmoothing;
    private double zoomSmoothing;

    OrbitViewInputSupport() {
        this(null);
    }

    OrbitViewInputSupport(OrbitView orbitView) {
        this.setOrbitView(orbitView);
        this.loadConfigurationValues();
        this.setViewOutOfFocus(true);
    }

    private void loadConfigurationValues() {
        this.setCenterMinEpsilon(1.0E-9);
        this.setHeadingMinEpsilon(1.0E-4);
        this.setPitchMinEpsilon(1.0E-4);
        this.setZoomMinEpsilon(0.001);
        this.setCenterSmoothing(0.4);
        this.setHeadingSmoothing(0.7);
        this.setPitchSmoothing(0.7);
        this.setZoomSmoothing(0.9);
    }

    public OrbitView getOrbitView() {
        return this.orbitView;
    }

    public void setOrbitView(OrbitView orbitView) {
        if (orbitView == this.orbitView) {
            return;
        }
        if (this.orbitView != null) {
            this.orbitView.removePropertyChangeListener(this);
        }
        this.orbitView = orbitView;
        if (this.orbitView != null) {
            this.orbitView.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.View.ViewStopped")) {
            this.clearTargets();
        } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("gov.nasa.worldwind.view.OrbitView.CenterStopped")) {
            this.centerTarget = null;
            this.setViewOutOfFocus(false);
        }
    }

    private boolean isViewChanged() {
        boolean bl = this.viewChanged;
        this.viewChanged = false;
        return bl;
    }

    private void flagViewChanged() {
        this.viewChanged = true;
    }

    private void refreshView() {
        if (this.isViewChanged() && this.orbitView != null) {
            this.orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this);
        }
    }

    private boolean isViewOutOfFocus() {
        return this.viewOutOfFocus;
    }

    private void setViewOutOfFocus(boolean bl) {
        this.viewOutOfFocus = bl;
    }

    private void focusView() {
        if (this.orbitView == null) {
            return;
        }
        try {
            if (this.orbitView.canFocusOnViewportCenter()) {
                this.orbitView.focusOnViewportCenter();
                this.setViewOutOfFocus(false);
                this.flagViewChanged();
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            this.setViewOutOfFocus(true);
        }
    }

    private boolean isTargetStopped() {
        boolean bl = this.targetStopped;
        this.targetStopped = false;
        return bl;
    }

    private void flagTargetStopped() {
        this.targetStopped = true;
    }

    public Position getCenterTarget() {
        return this.centerTarget;
    }

    public void setCenterTarget(Position position) {
        Position position2 = OrbitViewInputSupport.clampedCenter(position);
        if (this.centerSmoothing == 0.0 && position2 != null && this.orbitView != null) {
            this.centerTarget = null;
            this.orbitView.setCenterPosition(position2);
            this.flagViewChanged();
            this.setViewOutOfFocus(true);
        } else {
            this.centerTarget = position2;
        }
        if (position2 != null) {
            this.headingTarget = null;
            this.pitchTarget = null;
            this.zoomTarget = -1.0;
        }
        this.refreshView();
    }

    public Angle getHeadingTarget() {
        return this.headingTarget;
    }

    public void setHeadingTarget(Angle angle) {
        Angle angle2 = OrbitViewInputSupport.normalizedHeading(angle);
        if (this.isViewOutOfFocus()) {
            this.focusView();
        }
        if (this.headingSmoothing == 0.0 && angle2 != null && this.orbitView != null) {
            this.headingTarget = null;
            this.orbitView.setHeading(angle2);
            this.flagViewChanged();
        } else {
            this.headingTarget = angle2;
        }
        if (angle2 != null) {
            this.centerTarget = null;
            this.zoomTarget = -1.0;
        }
        this.refreshView();
    }

    public Angle getPitchTarget() {
        return this.pitchTarget;
    }

    public void setPitchTarget(Angle angle) {
        Angle angle2 = OrbitViewInputSupport.clampedPitch(angle);
        if (this.isViewOutOfFocus()) {
            this.focusView();
        }
        if (this.pitchSmoothing == 0.0 && angle2 != null && this.orbitView != null) {
            this.pitchTarget = null;
            this.orbitView.setPitch(angle2);
            this.flagViewChanged();
        } else {
            this.pitchTarget = angle2;
        }
        if (angle2 != null) {
            this.centerTarget = null;
            this.zoomTarget = -1.0;
        }
        this.refreshView();
    }

    public double getZoomTarget() {
        return this.zoomTarget;
    }

    public void setZoomTarget(double d) {
        double d2 = OrbitViewInputSupport.normalizedZoom(d);
        if (this.isViewOutOfFocus()) {
            double d3 = this.orbitView.getZoom();
            this.focusView();
            double d4 = this.orbitView.getZoom();
            d2 = OrbitViewInputSupport.normalizedZoom(d2 + (d4 - d3));
        }
        if (this.zoomSmoothing == 0.0 && d2 >= 0.0 && this.orbitView != null) {
            this.zoomTarget = -1.0;
            this.orbitView.setZoom(d2);
            this.flagViewChanged();
        } else {
            this.zoomTarget = d2;
        }
        if (d2 >= 0.0) {
            this.centerTarget = null;
            this.headingTarget = null;
            this.pitchTarget = null;
        }
        this.refreshView();
    }

    public boolean hasTargets() {
        return this.centerTarget != null || this.headingTarget != null || this.pitchTarget != null || this.zoomTarget >= 0.0;
    }

    public void clearTargets() {
        this.centerTarget = null;
        this.headingTarget = null;
        this.pitchTarget = null;
        this.zoomTarget = -1.0;
        this.viewChanged = false;
        this.setViewOutOfFocus(false);
        this.targetStopped = false;
    }

    private static Position clampedCenter(Position position) {
        if (position == null) {
            return null;
        }
        double d = position.getLatitude().degrees;
        double d2 = position.getLongitude().degrees;
        double d3 = position.getElevation();
        return Position.fromDegrees(d > 90.0 ? 90.0 : (d < -90.0 ? -90.0 : d), d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : (d2 %= 360.0)), d3);
    }

    private static Angle normalizedHeading(Angle angle) {
        if (angle == null) {
            return null;
        }
        double d = angle.degrees;
        double d2 = d % 360.0;
        return Angle.fromDegrees(d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2));
    }

    private static Angle clampedPitch(Angle angle) {
        if (angle == null) {
            return null;
        }
        double d = angle.degrees;
        return Angle.fromDegrees(d > 90.0 ? 90.0 : (d < 0.0 ? 0.0 : d));
    }

    private static double normalizedZoom(double d) {
        return d < 0.0 ? -1.0 : d;
    }

    public double getCenterMinEpsilon() {
        return this.centerMinEpsilon;
    }

    public void setCenterMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerMinEpsilon = d;
    }

    public double getHeadingMinEpsilon() {
        return this.headingMinEpsilon;
    }

    public void setHeadingMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.headingMinEpsilon = d;
    }

    public double getPitchMinEpsilon() {
        return this.pitchMinEpsilon;
    }

    public void setPitchMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitchMinEpsilon = d;
    }

    public double getZoomMinEpsilon() {
        return this.zoomMinEpsilon;
    }

    public void setZoomMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zoomMinEpsilon = d;
    }

    public double getCenterSmoothing() {
        return this.centerSmoothing;
    }

    public void setCenterSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerSmoothing = d;
    }

    public double getHeadingSmoothing() {
        return this.headingSmoothing;
    }

    public void setHeadingSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.headingSmoothing = d;
    }

    public double getPitchSmoothing() {
        return this.pitchSmoothing;
    }

    public void setPitchSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitchSmoothing = d;
    }

    public double getZoomSmoothing() {
        return this.zoomSmoothing;
    }

    public void setZoomSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zoomSmoothing = d;
    }

    public void moveViewTowardTargets() {
        if (this.orbitView == null) {
            return;
        }
        this.isViewChanged();
        this.isTargetStopped();
        if (this.centerTarget != null) {
            this.moveTowardCenterTarget();
        }
        if (this.headingTarget != null) {
            this.moveTowardHeadingTarget();
        }
        if (this.pitchTarget != null) {
            this.moveTowardPitchTarget();
        }
        if (this.zoomTarget >= 0.0) {
            this.moveTowardZoomTarget();
        }
        this.refreshView();
        if (this.isTargetStopped() && !this.hasTargets()) {
            if (this.isViewOutOfFocus()) {
                this.focusView();
            }
            this.clearTargets();
            this.orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewQuiet", null, this.orbitView);
        }
    }

    private void moveTowardCenterTarget() {
        boolean bl;
        Position position = this.centerTarget;
        Position position2 = this.orbitView.getCenterPosition();
        double d = LatLon.greatCircleDistance((LatLon)position.getLatLon(), (LatLon)position2.getLatLon()).degrees;
        double d2 = Math.abs(position.getElevation() - position2.getElevation());
        boolean bl2 = bl = Math.max(d, d2) < this.centerMinEpsilon;
        if (!bl) {
            double d3 = 1.0 - this.centerSmoothing;
            position = new Position(Angle.mix(d3, position2.getLatitude(), this.centerTarget.getLatitude()), Angle.mix(d3, position2.getLongitude(), this.centerTarget.getLongitude()), (1.0 - d3) * position2.getElevation() + d3 * this.centerTarget.getElevation());
        }
        try {
            this.orbitView.hadCollisions();
            this.orbitView.setCenterPosition(position);
            if (this.orbitView.hadCollisions()) {
                this.centerTarget = new Position(this.centerTarget.getLatLon(), this.orbitView.getCenterPosition().getElevation());
            }
            this.flagViewChanged();
            this.setViewOutOfFocus(true);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.centerTarget = null;
            this.flagTargetStopped();
        }
    }

    private void moveTowardHeadingTarget() {
        boolean bl;
        Angle angle = this.headingTarget;
        Angle angle2 = this.orbitView.getHeading();
        double d = Math.abs(angle.subtract((Angle)angle2).degrees);
        boolean bl2 = bl = d < this.headingMinEpsilon;
        if (!bl) {
            double d2 = 1.0 - this.headingSmoothing;
            angle = Angle.mix(d2, angle2, this.headingTarget);
        }
        try {
            this.orbitView.setHeading(angle);
            this.flagViewChanged();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.headingTarget = null;
            this.flagTargetStopped();
        }
    }

    private void moveTowardPitchTarget() {
        boolean bl;
        Angle angle = this.pitchTarget;
        Angle angle2 = this.orbitView.getPitch();
        double d = Math.abs(angle.subtract((Angle)angle2).degrees);
        boolean bl2 = bl = d < this.pitchMinEpsilon;
        if (!bl) {
            double d2 = 1.0 - this.pitchSmoothing;
            angle = Angle.mix(d2, angle2, this.pitchTarget);
        }
        try {
            this.orbitView.hadCollisions();
            this.orbitView.setPitch(angle);
            if (this.orbitView.hadCollisions()) {
                bl = true;
            }
            this.flagViewChanged();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.pitchTarget = null;
            this.flagTargetStopped();
        }
    }

    private void moveTowardZoomTarget() {
        boolean bl;
        double d = this.zoomTarget;
        double d2 = this.orbitView.getZoom();
        double d3 = Math.abs(d - d2);
        boolean bl2 = bl = d3 < this.zoomMinEpsilon;
        if (!bl) {
            double d4 = 1.0 - this.zoomSmoothing;
            d = (1.0 - d4) * d2 + d4 * this.zoomTarget;
        }
        try {
            this.orbitView.setZoom(d);
            this.flagViewChanged();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.zoomTarget = -1.0;
            this.flagTargetStopped();
        }
    }
}

