/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.KeyPollTimer;
import gov.nasa.worldwind.awt.OrbitViewInputSupport;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.ScheduledOrbitViewStateIterator;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;

public class OrbitViewInputBroker
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
FocusListener,
RenderingListener {
    private OrbitView view;
    private WorldWindow wwd;
    private OrbitViewInputSupport orbitViewInputSupport = new OrbitViewInputSupport();
    private boolean smoothViewChanges = true;
    private boolean lockHeading = true;
    private Point mousePoint = null;
    private Position selectedPosition = null;
    private final Integer[] POLLED_KEYS = new Integer[]{37, 39, 38, 40, 33, 34, 107, 61, 109, 45};
    private KeyPollTimer keyPollTimer = new KeyPollTimer(25, Arrays.asList(this.POLLED_KEYS), new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            Object object = actionEvent.getSource();
            if (object == null || !(object instanceof Integer)) {
                return;
            }
            OrbitViewInputBroker.this.keyPolled((Integer)object, actionEvent.getModifiers());
        }
    });

    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    public void setWorldWindow(WorldWindow worldWindow) {
        if (worldWindow == this.wwd) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.removeRenderingListener(this);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.addRenderingListener(this);
        }
        this.view = this.wwd != null && this.wwd.getView() != null && this.wwd.getView() instanceof OrbitView ? (OrbitView)this.wwd.getView() : null;
        this.orbitViewInputSupport.setOrbitView(this.view);
    }

    public boolean isSmoothViewChanges() {
        return this.smoothViewChanges;
    }

    public void setSmoothViewChanges(boolean bl) {
        this.smoothViewChanges = bl;
    }

    public boolean isLockHeading() {
        return this.lockHeading;
    }

    public void setLockHeading(boolean bl) {
        this.lockHeading = bl;
    }

    private Point getMousePoint() {
        return this.mousePoint;
    }

    private void updateMousePoint(MouseEvent mouseEvent) {
        this.mousePoint = mouseEvent != null ? (this.wwd instanceof Component ? this.constrainPointToComponentBounds(mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)this.wwd)) : new Point(mouseEvent.getX(), mouseEvent.getY())) : null;
    }

    private Point constrainPointToComponentBounds(int n, int n2, Component component) {
        if (component != null) {
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n > component.getWidth()) {
                n = component.getWidth();
            }
            if (n2 > component.getHeight()) {
                n2 = component.getHeight();
            }
        }
        return new Point(n, n2);
    }

    private void updateSelectedPosition() {
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        this.selectedPosition = pickedObjectList != null && pickedObjectList.getTopPickedObject() != null && pickedObjectList.getTopPickedObject().isTerrain() ? pickedObjectList.getTopPickedObject().getPosition() : null;
    }

    private void clearSelectedPosition() {
        this.selectedPosition = null;
    }

    private Position computePositionAtPoint(double d, double d2) {
        Position position = null;
        if (this.view != null && this.wwd != null && this.wwd.getModel() != null && this.wwd.getModel().getGlobe() != null) {
            Globe globe = this.wwd.getModel().getGlobe();
            Line line = this.view.computeRayFromScreenPoint(d, d2);
            if (line != null) {
                Intersection[] intersectionArray;
                double d3;
                double d4 = this.view.getEyePosition().getElevation();
                double d5 = d3 = this.selectedPosition != null ? this.selectedPosition.getElevation() : 0.0;
                if (d4 > d3 && (intersectionArray = globe.intersect(line, d3)) != null && intersectionArray.length != 0) {
                    position = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
                }
            }
        }
        return position;
    }

    public void keyPolled(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl;
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        int n3 = n2 & 0x200;
        boolean bl2 = bl = n3 != 0;
        if (OrbitViewInputBroker.areModifiersExactly(n2, n3) && this.isLockHeading()) {
            d4 = this.view.getHeading().sin();
            d3 = this.view.getHeading().cos();
            d2 = 0.0;
            d = 0.0;
            if (n == 37) {
                d2 = d4;
                d = -d3;
            } else if (n == 39) {
                d2 = -d4;
                d = d3;
            } else if (n == 38) {
                d2 = d3;
                d = d4;
            } else if (n == 40) {
                d2 = -d3;
                d = -d4;
            }
            if (d2 != 0.0 || d != 0.0) {
                Angle angle = this.computeLatOrLonChange(d2, bl);
                Angle angle2 = this.computeLatOrLonChange(d, bl);
                this.setCenterLatLon(this.view.getCenterPosition().getLatitude().add(angle), this.view.getCenterPosition().getLongitude().add(angle2));
                return;
            }
        }
        d4 = 0.0;
        d3 = 0.0;
        if (OrbitViewInputBroker.areModifiersExactly(n2, n3)) {
            if (n == 34) {
                d3 = 1.0;
            } else if (n == 33) {
                d3 = -1.0;
            }
        } else if (OrbitViewInputBroker.areModifiersExactly(n2, 0x40 | n3)) {
            if (n == 37) {
                d4 = -1.0;
            } else if (n == 39) {
                d4 = 1.0;
            } else if (n == 38) {
                d3 = -1.0;
            } else if (n == 40) {
                d3 = 1.0;
            }
        }
        if (d4 != 0.0) {
            Angle angle = this.computeNewHeading(4.0 * d4, bl);
            this.setHeading(angle);
            return;
        }
        if (d3 != 0.0) {
            Angle angle = this.computeNewPitch(4.0 * d3, bl);
            this.setPitch(angle);
            return;
        }
        d2 = 0.0;
        if (OrbitViewInputBroker.areModifiersExactly(n2, n3)) {
            if (n == 107 || n == 61) {
                d2 = -1.0;
            } else if (n == 109 || n == 45) {
                d2 = 1.0;
            }
        } else if (OrbitViewInputBroker.areModifiersExactly(n2, 0x80 | n3) || OrbitViewInputBroker.areModifiersExactly(n2, 0x100 | n3)) {
            if (n == 38) {
                d2 = -1.0;
            } else if (n == 40) {
                d2 = 1.0;
            }
        }
        if (d2 != 0.0) {
            d = this.computeNewZoom(d2, bl);
            this.setZoom(d);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyPollTimer.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyPollTimer.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyPollTimer.keyReleased(keyEvent);
        int n = keyEvent.getKeyCode();
        if (n == 32) {
            this.stopViewMovement();
        } else if (n == 78) {
            this.view.applyStateIterator(ScheduledOrbitViewStateIterator.createHeadingIterator(this.view.getHeading(), Angle.ZERO));
        } else if (n == 82) {
            this.view.applyStateIterator(ScheduledOrbitViewStateIterator.createHeadingPitchIterator(this.view.getHeading(), Angle.ZERO, this.view.getPitch(), Angle.ZERO));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (pickedObjectList == null || pickedObjectList.getTopPickedObject() == null || !pickedObjectList.getTopPickedObject().isTerrain()) {
            return;
        }
        PickedObject pickedObject = pickedObjectList.getTopPickedObject();
        Position position = pickedObject.getPosition();
        if (this.isLockHeading()) {
            this.orbitViewInputSupport.setCenterTarget(null);
            Position position2 = new Position(position.getLatLon(), this.view.getCenterPosition().getElevation());
            this.setCenterPosition(position2, true, 0.9);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
        this.updateSelectedPosition();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
        this.clearSelectedPosition();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        Point point = this.getMousePoint();
        this.updateMousePoint(mouseEvent);
        Point point2 = this.getMousePoint();
        Point point3 = null;
        if (point2 != null && point != null) {
            point3 = new Point(point2.x - point.x, point2.y - point.y);
        }
        if (this.selectedPosition == null) {
            this.updateSelectedPosition();
        }
        if (OrbitViewInputBroker.areModifiersExactly(mouseEvent, 1024)) {
            if (point != null && point2 != null) {
                Position position = this.computePositionAtPoint(point.x, point.y);
                Position position2 = this.computePositionAtPoint(point2.x, point2.y);
                if (position != null && position2 != null) {
                    if (!position.equals(position2) && this.isLockHeading()) {
                        this.setCenterLatLon(this.view.getCenterPosition().getLatitude().add(position.getLatitude()).subtract(position2.getLatitude()), this.view.getCenterPosition().getLongitude().add(position.getLongitude()).subtract(position2.getLongitude()));
                    }
                } else {
                    if (this.isLockHeading()) {
                        double d = this.view.getHeading().sin();
                        double d2 = this.view.getHeading().cos();
                        double d3 = (d2 * (double)point3.y + d * (double)point3.x) / 10.0;
                        double d4 = (d * (double)point3.y - d2 * (double)point3.x) / 10.0;
                        Angle angle = this.computeLatOrLonChange(d3, false);
                        Angle angle2 = this.computeLatOrLonChange(d4, false);
                        this.setCenterLatLon(this.view.getCenterPosition().getLatitude().add(angle), this.view.getCenterPosition().getLongitude().add(angle2));
                    }
                    this.clearSelectedPosition();
                }
            }
        } else if (OrbitViewInputBroker.areModifiersExactly(mouseEvent, 4096) || OrbitViewInputBroker.areModifiersExactly(mouseEvent, 1152)) {
            if (point3 != null) {
                if (point3.x != 0) {
                    Object object;
                    double d = 1.0;
                    Object object2 = mouseEvent.getSource();
                    if (object2 != null && object2 instanceof Component && mouseEvent.getPoint().y < ((Component)(object = (Component)object2)).getHeight() / 2) {
                        d = -1.0;
                    }
                    object = this.computeNewHeading(d * (double)point3.x, false);
                    this.setHeading((Angle)object);
                }
                if (point3.y != 0) {
                    Angle angle = this.computeNewPitch(point3.y, false);
                    this.setPitch(angle);
                }
            }
        } else if (OrbitViewInputBroker.areModifiersExactly(mouseEvent, 2048) && point3 != null && point3.y != 0) {
            double d = (double)point3.y / 10.0;
            double d5 = this.computeNewZoom(d, false);
            this.setZoom(d5);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (mouseWheelEvent == null) {
            return;
        }
        int n = mouseWheelEvent.getWheelRotation();
        double d = Math.signum(n);
        double d2 = this.computeNewZoom(d, false);
        this.setZoom(d2);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.stopViewMovement();
        this.keyPollTimer.stop();
    }

    public void stageChanged(RenderingEvent renderingEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.view == null) {
            return;
        }
        if (renderingEvent == null) {
            return;
        }
        if (renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.BeforeRendering")) {
            if (this.view.hasStateIterator()) {
                this.orbitViewInputSupport.clearTargets();
            }
            if (this.orbitViewInputSupport.hasTargets()) {
                this.orbitViewInputSupport.moveViewTowardTargets();
            }
        }
    }

    private static boolean areModifiersExactly(InputEvent inputEvent, int n) {
        return OrbitViewInputBroker.areModifiersExactly(inputEvent.getModifiersEx(), n);
    }

    private static boolean areModifiersExactly(int n, int n2) {
        return n == n2;
    }

    private void stopViewMovement() {
        if (this.view == null) {
            return;
        }
        this.view.stopMovement();
    }

    private void stopViewIterators() {
        if (this.view == null) {
            return;
        }
        if (this.view.hasStateIterator()) {
            this.view.stopStateIterators();
        }
    }

    private void fireViewChangedEvent() {
        if (this.view == null) {
            return;
        }
        this.view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.view);
    }

    private void setCenterLatLon(Angle angle, Angle angle2) {
        if (this.view == null) {
            return;
        }
        this.setCenterPosition(new Position(angle, angle2, this.view.getCenterPosition().getElevation()));
    }

    private void setCenterPosition(Position position) {
        if (this.view == null) {
            return;
        }
        this.setCenterPosition(position, this.smoothViewChanges, 0.4);
    }

    private void setCenterPosition(Position position, boolean bl, double d) {
        if (this.view == null) {
            return;
        }
        this.stopViewIterators();
        Position position2 = this.orbitViewInputSupport.getCenterTarget();
        if (bl && position2 != null) {
            Position position3 = this.view.getCenterPosition();
            position = new Position(position2.getLatitude().add(position.getLatitude()).subtract(position3.getLatitude()), position2.getLongitude().add(position.getLongitude()).subtract(position3.getLongitude()), position2.getElevation() + position.getElevation() - position3.getElevation());
        }
        this.orbitViewInputSupport.setCenterSmoothing(bl ? d : 0.0);
        this.orbitViewInputSupport.setCenterTarget(position);
        this.fireViewChangedEvent();
    }

    private void setHeading(Angle angle) {
        if (this.view == null) {
            return;
        }
        this.setHeading(angle, this.smoothViewChanges, 0.7);
    }

    private void setHeading(Angle angle, boolean bl, double d) {
        if (this.view == null) {
            return;
        }
        this.stopViewIterators();
        Angle angle2 = this.orbitViewInputSupport.getHeadingTarget();
        if (bl && angle2 != null) {
            angle = angle2.add(angle).subtract(this.view.getHeading());
        }
        this.orbitViewInputSupport.setHeadingSmoothing(bl ? d : 0.0);
        this.orbitViewInputSupport.setHeadingTarget(angle);
        this.fireViewChangedEvent();
    }

    private void setPitch(Angle angle) {
        if (this.view == null) {
            return;
        }
        this.setPitch(angle, this.smoothViewChanges, 0.7);
    }

    private void setPitch(Angle angle, boolean bl, double d) {
        if (this.view == null) {
            return;
        }
        this.stopViewIterators();
        Angle angle2 = this.orbitViewInputSupport.getPitchTarget();
        if (bl && angle2 != null) {
            angle = angle2.add(angle).subtract(this.view.getPitch());
        }
        this.orbitViewInputSupport.setPitchSmoothing(bl ? d : 0.0);
        this.orbitViewInputSupport.setPitchTarget(angle);
        this.fireViewChangedEvent();
    }

    private void setZoom(double d) {
        if (this.view == null) {
            return;
        }
        this.setZoom(d, this.smoothViewChanges, 0.9);
    }

    private void setZoom(double d, boolean bl, double d2) {
        if (this.view == null) {
            return;
        }
        this.stopViewIterators();
        double d3 = this.orbitViewInputSupport.getZoomTarget();
        if (bl && d3 >= 0.0) {
            d = this.computeNewZoomTarget(d3, d, this.view.getZoom());
        }
        this.orbitViewInputSupport.setZoomSmoothing(bl ? d2 : 0.0);
        this.orbitViewInputSupport.setZoomTarget(d);
        this.fireViewChangedEvent();
    }

    private Angle computeLatOrLonChange(double d, boolean bl) {
        if (this.wwd == null || this.wwd.getModel() == null || this.wwd.getModel().getGlobe() == null || this.view == null || this.view.getEyePosition() == null) {
            return Angle.ZERO;
        }
        Position position = this.view.getEyePosition();
        double d2 = position.getElevation() / this.wwd.getModel().getGlobe().getRadiusAt(position.getLatLon());
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 1.0) {
            d2 = 1.0;
        }
        double d3 = 1.0E-4 * (1.0 - d2) + 2.0 * d2;
        if (bl) {
            d3 /= 4.0;
        }
        return Angle.fromDegrees(d3 * d);
    }

    private Angle computeNewHeading(double d, boolean bl) {
        if (this.view == null) {
            return Angle.ZERO;
        }
        return this.computeNewHeadingOrPitch(this.view.getHeading(), d, bl);
    }

    private Angle computeNewPitch(double d, boolean bl) {
        if (this.view == null) {
            return Angle.ZERO;
        }
        return this.computeNewHeadingOrPitch(this.view.getPitch(), d, bl);
    }

    private Angle computeNewHeadingOrPitch(Angle angle, double d, boolean bl) {
        double d2 = 0.25;
        if (bl) {
            d2 /= 4.0;
        }
        Angle angle2 = Angle.fromDegrees(d2 * d);
        return angle.add(angle2);
    }

    private double computeNewZoom(double d, boolean bl) {
        if (this.view == null) {
            return 0.0;
        }
        double d2 = 0.05;
        if (bl) {
            d2 /= 4.0;
        }
        double d3 = d2 * d;
        double d4 = this.view.getZoom() != 0.0 ? Math.log(this.view.getZoom()) : 0.0;
        return Math.exp(d4 + d3);
    }

    private double computeNewZoomTarget(double d, double d2, double d3) {
        double d4 = d != 0.0 ? Math.log(d) : 0.0;
        double d5 = d2 != 0.0 ? Math.log(d2) : 0.0;
        double d6 = d3 != 0.0 ? Math.log(d3) : 0.0;
        return Math.exp(d4 + d5 - d6);
    }
}

