/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.applications.sar.SAR2;
import gov.nasa.worldwind.applications.sar.SARTrack;
import gov.nasa.worldwind.geom.Position;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrackViewPanel
extends JPanel {
    private SARTrack sarTrack;
    private String elevationUnit;
    private JCheckBox subsurfaceButton;
    private JRadioButton examineButton;
    private JRadioButton followButton;
    private JRadioButton freeButton;
    private JCheckBox overrideClipDistanceButton;
    private JSlider clipDistanceSlider;
    private JLabel latLabel;
    private JLabel lonLabel;
    private JLabel altLabel;
    private JLabel latReadout;
    private JLabel lonReadout;
    private JLabel altReadout;
    private JSpinner positionSpinner;
    private JSlider positionSlider;
    private JButton fastReverseButton;
    private JButton reverseButton;
    private JButton stopButton;
    private JButton forwardButton;
    private JButton fastForwardButton;
    private JLabel speedLabel;
    private JSlider speedSlider;
    private static final int PLAY_FORWARD = 1;
    private static final int PLAY_BACKWARD = -1;
    private static final int PLAY_STOP = 0;
    private int playMode = 0;
    private Timer player;
    public static final String POSITION_CHANGE = "TrackViewPanel.PositionChange";
    public static final String VIEW_CHANGE = "TrackViewPanel.ViewChange";

    public TrackViewPanel() {
        this.initComponents();
        this.updateEnabledState();
    }

    public void setCurrentTrack(SARTrack sARTrack) {
        this.sarTrack = sARTrack;
        if (this.sarTrack != null) {
            this.sarTrack.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TrackViewPanel.this.updatePositionList(false);
                }
            });
        }
        this.updatePositionList(true);
        this.updateEnabledState();
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        this.elevationUnit = string;
    }

    private void updatePositionList(boolean bl) {
        Object[] objectArray = new String[this.sarTrack != null ? this.sarTrack.size() : 0];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = String.format("%,4d", i);
        }
        if (objectArray.length == 0) {
            objectArray = new String[]{"   0"};
        }
        Object object = this.positionSpinner.getValue();
        int n = this.positionSlider.getValue();
        this.positionSpinner.setModel(new SpinnerListModel(objectArray));
        this.positionSpinner.setValue(bl ? objectArray[0] : object);
        this.positionSlider.setValue(bl ? 0 : n);
    }

    private void setPositionSpinnerNumber(int n) {
        this.positionSpinner.setValue(String.format("%,4d", n));
    }

    private void updateEnabledState() {
        boolean bl = this.sarTrack != null;
        this.examineButton.setEnabled(bl);
        this.followButton.setEnabled(bl);
        this.positionSpinner.setEnabled(bl);
        this.positionSlider.setEnabled(bl);
        this.speedLabel.setEnabled(bl);
        this.latLabel.setEnabled(bl);
        this.lonLabel.setEnabled(bl);
        this.altLabel.setEnabled(bl);
        this.fastReverseButton.setEnabled(bl);
        this.reverseButton.setEnabled(bl);
        this.forwardButton.setEnabled(bl);
        this.fastForwardButton.setEnabled(bl);
        this.speedLabel.setEnabled(bl);
        this.speedSlider.setEnabled(bl);
        this.updateReadout(this.sarTrack != null && this.sarTrack.size() > 0 ? this.sarTrack.get(0) : null);
    }

    private void positionSpinnerStateChanged() {
        this.positionSlider.setValue(0);
        this.firePropertyChange(POSITION_CHANGE, -1, 0);
    }

    private void positionSliderStateChanged() {
        this.firePropertyChange(POSITION_CHANGE, -1, 0);
    }

    private void examineButtonItemStateChanged() {
        this.subsurfaceButton.setSelected(false);
        this.firePropertyChange(VIEW_CHANGE, -1, 0);
    }

    private void followButtonItemStateChanged() {
        this.subsurfaceButton.setSelected(true);
        this.firePropertyChange(VIEW_CHANGE, -1, 0);
    }

    private void freeButtonItemStateChanged() {
        this.subsurfaceButton.setSelected(false);
        this.firePropertyChange(VIEW_CHANGE, -1, 0);
    }

    private void subsurfaceButtonItemStateChanged() {
        this.firePropertyChange(VIEW_CHANGE, -1, 0);
    }

    private void overrideClipDistanceButtonStateChanged() {
        this.subsurfaceButton.setEnabled(!this.overrideClipDistanceButton.isSelected());
        this.firePropertyChange(POSITION_CHANGE, -1, 0);
    }

    private void clipDistanceStateChanged() {
        this.firePropertyChange(POSITION_CHANGE, -1, 0);
    }

    public int getCurrentPositionNumber() {
        Object object = this.positionSpinner.getValue();
        if (object == null) {
            return -1;
        }
        return Integer.parseInt(object.toString().trim().replaceAll(",", ""));
    }

    private boolean isLastPosition(int n) {
        return n >= this.sarTrack.size() - 1;
    }

    public double getPositionDelta() {
        int n = this.positionSlider.getValue();
        int n2 = this.positionSlider.getMinimum();
        int n3 = this.positionSlider.getMaximum();
        return (double)n / ((double)n3 - (double)n2);
    }

    public boolean isSubsurfaceOkay() {
        return this.subsurfaceButton.isSelected();
    }

    public boolean isExamineViewMode() {
        return this.examineButton.isSelected();
    }

    public boolean isFollowViewMode() {
        return this.followButton.isSelected();
    }

    public boolean isFreeViewMode() {
        return this.freeButton.isSelected();
    }

    public boolean isOverrideClipDistance() {
        return this.overrideClipDistanceButton.isSelected();
    }

    public double getClipDistance() {
        return this.clipDistanceSlider.getValue();
    }

    public void updateReadout(Position position) {
        this.latReadout.setText(position == null ? "" : String.format("% 7.4f\u00b0", position.getLatitude().getDegrees()));
        this.lonReadout.setText(position == null ? "" : String.format("% 7.4f\u00b0", position.getLongitude().getDegrees()));
        if ("Imperial".equals(this.elevationUnit)) {
            this.altReadout.setText(position == null ? "" : String.format("% 8.0f ft", SAR2.metersToFeet(position.getElevation())));
        } else {
            this.altReadout.setText(position == null ? "" : String.format("% 8.0f m", position.getElevation()));
        }
    }

    private void fastReverseButtonActionPerformed() {
        if (this.getCurrentPositionNumber() > 0) {
            this.setPositionSpinnerNumber(this.getCurrentPositionNumber() - 1);
        }
    }

    private void reverseButtonActionPerformed() {
        this.setPlayMode(-1);
    }

    private void stopButtonActionPerformed() {
        this.setPlayMode(0);
    }

    private void forwardButtonActionPerformed() {
        this.setPlayMode(1);
    }

    private void fastForwardButtonActionPerformed() {
        if (!this.isLastPosition(this.getCurrentPositionNumber())) {
            this.setPositionSpinnerNumber(this.getCurrentPositionNumber() + 1);
        }
    }

    public boolean isPlayerActive() {
        return this.playMode != 0;
    }

    private void setPlayMode(int n) {
        this.playMode = n;
        if (this.player == null) {
            this.initPlayer();
        }
        this.player.start();
    }

    private void initPlayer() {
        if (this.player != null) {
            return;
        }
        this.player = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.runPlayer();
            }
        });
    }

    private void runPlayer() {
        int n = this.getCurrentPositionNumber();
        int n2 = this.positionSlider.getValue();
        int n3 = this.speedSlider.getValue() / 10;
        if (this.playMode == 0) {
            this.stopButton.setEnabled(false);
            this.player.stop();
        } else if (this.playMode == 1) {
            this.stopButton.setEnabled(true);
            if (n >= this.sarTrack.size() - 1) {
                this.playMode = 0;
                this.setPositionSpinnerNumber(this.sarTrack.size() - 1);
            } else {
                int n4 = n2 + n3;
                if (n4 > this.positionSlider.getMaximum()) {
                    int n5 = n + 1;
                    if (n5 >= this.sarTrack.size() - 1) {
                        this.playMode = 0;
                        this.setPositionSpinnerNumber(this.sarTrack.size() - 1);
                    } else {
                        this.setPositionSpinnerNumber(n5);
                    }
                } else {
                    this.positionSlider.setValue(n4);
                }
            }
        } else if (this.playMode == -1) {
            this.stopButton.setEnabled(true);
            if (n >= this.sarTrack.size() - 1) {
                this.setPositionSpinnerNumber(n - 1);
                this.positionSlider.setValue(this.positionSlider.getMaximum());
            } else {
                int n6 = n2 - n3;
                if (n6 < this.positionSlider.getMinimum()) {
                    int n7 = n - 1;
                    if (n7 < 0) {
                        this.playMode = 0;
                        this.setPositionSpinnerNumber(0);
                        this.positionSlider.setValue(0);
                    } else {
                        this.setPositionSpinnerNumber(n7);
                        this.positionSlider.setValue(this.positionSlider.getMaximum());
                    }
                } else {
                    this.positionSlider.setValue(n6);
                }
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        Box box = Box.createVerticalBox();
        box.setBorder(new CompoundBorder(new TitledBorder(BorderFactory.createMatteBorder(1, 5, 1, 1, Color.GRAY), "View"), new EmptyBorder(5, 5, 5, 5)));
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        this.subsurfaceButton = new JCheckBox();
        this.subsurfaceButton.setText("Subsurface");
        this.subsurfaceButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TrackViewPanel.this.subsurfaceButtonItemStateChanged();
            }
        });
        box2.add(this.subsurfaceButton);
        box2.add(Box.createHorizontalStrut(20));
        this.examineButton = new JRadioButton();
        this.examineButton.setText("EXAMINE");
        this.examineButton.setHorizontalAlignment(0);
        this.examineButton.setEnabled(false);
        this.examineButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TrackViewPanel.this.examineButtonItemStateChanged();
            }
        });
        box2.add(this.examineButton);
        box2.add(Box.createHorizontalStrut(20));
        this.followButton = new JRadioButton();
        this.followButton.setText("FLY-IT");
        this.followButton.setHorizontalAlignment(0);
        this.followButton.setEnabled(false);
        this.followButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TrackViewPanel.this.followButtonItemStateChanged();
            }
        });
        box2.add(this.followButton);
        box2.add(Box.createHorizontalStrut(20));
        this.freeButton = new JRadioButton();
        this.freeButton.setText("FREE");
        this.freeButton.setSelected(true);
        this.freeButton.setHorizontalAlignment(0);
        this.freeButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TrackViewPanel.this.freeButtonItemStateChanged();
            }
        });
        box2.add(this.freeButton);
        box2.add(Box.createHorizontalGlue());
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.examineButton);
        ((ButtonGroup)serializable).add(this.followButton);
        ((ButtonGroup)serializable).add(this.freeButton);
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        serializable = Box.createHorizontalBox();
        ((JComponent)serializable).setAlignmentX(0.0f);
        this.overrideClipDistanceButton = new JCheckBox();
        this.overrideClipDistanceButton.setText("Override Clip Distance:");
        this.overrideClipDistanceButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TrackViewPanel.this.overrideClipDistanceButtonStateChanged();
            }
        });
        ((Container)serializable).add(this.overrideClipDistanceButton);
        ((Container)serializable).add(Box.createHorizontalStrut(3));
        int n = 10;
        int n2 = 100000;
        this.clipDistanceSlider = new JSlider();
        this.clipDistanceSlider.setMinimum(n);
        this.clipDistanceSlider.setMaximum(n2);
        this.clipDistanceSlider.setValue(n + (n2 - n) / 2);
        this.clipDistanceSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TrackViewPanel.this.clipDistanceStateChanged();
            }
        });
        ((Container)serializable).add(this.clipDistanceSlider);
        box.add((Component)serializable);
        this.add(box);
        box2 = Box.createVerticalBox();
        box2.setBorder(new CompoundBorder(new TitledBorder(BorderFactory.createMatteBorder(1, 5, 1, 1, Color.GRAY), "Position"), new EmptyBorder(5, 5, 5, 5)));
        serializable = new JPanel();
        ((JComponent)serializable).setAlignmentX(0.0f);
        ((Container)serializable).setLayout(new GridLayout(1, 3));
        JComponent jComponent = Box.createHorizontalBox();
        this.latLabel = new JLabel();
        this.latLabel.setText("Lat:");
        jComponent.add(this.latLabel);
        jComponent.add(Box.createHorizontalStrut(3));
        this.latReadout = new JLabel();
        this.latReadout.setText("-90.0000");
        jComponent.add(this.latReadout);
        jComponent.add(Box.createHorizontalGlue());
        ((Container)serializable).add(jComponent);
        Box box3 = Box.createHorizontalBox();
        this.lonLabel = new JLabel();
        this.lonLabel.setText("Lon:");
        box3.add(this.lonLabel);
        box3.add(Box.createHorizontalStrut(3));
        this.lonReadout = new JLabel();
        this.lonReadout.setText("-180.0000");
        box3.add(this.lonReadout);
        box3.add(Box.createHorizontalGlue());
        ((Container)serializable).add(box3);
        Box box4 = Box.createHorizontalBox();
        this.altLabel = new JLabel();
        this.altLabel.setText("Alt:");
        box4.add(this.altLabel);
        box4.add(Box.createHorizontalStrut(3));
        this.altReadout = new JLabel();
        this.altReadout.setText("50,000.000");
        box4.add(this.altReadout);
        box4.add(Box.createHorizontalGlue());
        ((Container)serializable).add(box4);
        box2.add((Component)serializable);
        box2.add(Box.createVerticalStrut(5));
        jComponent = new JPanel();
        jComponent.setAlignmentX(0.0f);
        jComponent.setLayout(new BorderLayout(5, 0));
        this.positionSpinner = new JSpinner();
        this.positionSpinner.setModel(new SpinnerListModel(new String[]{"   0"}));
        this.positionSpinner.setEnabled(false);
        this.positionSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TrackViewPanel.this.positionSpinnerStateChanged();
            }
        });
        jComponent.add((Component)this.positionSpinner, "West");
        this.positionSlider = new JSlider();
        this.positionSlider.setMaximum(1000);
        this.positionSlider.setValue(0);
        this.positionSlider.setEnabled(false);
        this.positionSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TrackViewPanel.this.positionSliderStateChanged();
            }
        });
        jComponent.add((Component)this.positionSlider, "Center");
        box2.add(jComponent);
        box2.add(Box.createVerticalStrut(10));
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        this.fastReverseButton = new JButton();
        this.fastReverseButton.setText("<<");
        this.fastReverseButton.setEnabled(false);
        this.fastReverseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.fastReverseButtonActionPerformed();
            }
        });
        box3.add(this.fastReverseButton);
        box3.add(Box.createHorizontalStrut(3));
        this.reverseButton = new JButton();
        this.reverseButton.setText("<");
        this.reverseButton.setEnabled(false);
        this.reverseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.reverseButtonActionPerformed();
            }
        });
        box3.add(this.reverseButton);
        box3.add(Box.createHorizontalStrut(3));
        this.stopButton = new JButton();
        this.stopButton.setText("Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.stopButtonActionPerformed();
            }
        });
        box3.add(this.stopButton);
        box3.add(Box.createHorizontalStrut(3));
        this.forwardButton = new JButton();
        this.forwardButton.setText(">");
        this.forwardButton.setBorder(UIManager.getBorder("Button.border"));
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.forwardButtonActionPerformed();
            }
        });
        box3.add(this.forwardButton);
        box3.add(Box.createHorizontalStrut(3));
        this.fastForwardButton = new JButton();
        this.fastForwardButton.setText(">>");
        this.fastForwardButton.setEnabled(false);
        this.fastForwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.fastForwardButtonActionPerformed();
            }
        });
        box3.add(this.fastForwardButton);
        box3.add(Box.createHorizontalGlue());
        box2.add(box3);
        box2.add(Box.createVerticalStrut(5));
        box4 = Box.createHorizontalBox();
        box4.setAlignmentX(0.0f);
        this.speedLabel = new JLabel();
        this.speedLabel.setText("Speed:");
        box4.add(this.speedLabel);
        box4.add(Box.createHorizontalStrut(5));
        this.speedSlider = new JSlider();
        this.speedSlider.setMaximum(200);
        this.speedSlider.setMajorTickSpacing(50);
        this.speedSlider.setPaintLabels(true);
        this.speedSlider.setValue(20);
        this.speedSlider.setEnabled(false);
        box4.add(this.speedSlider);
        box2.add(box4);
        this.add(box2);
    }
}

