/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.applications.sar.AnalysisPanel;
import gov.nasa.worldwind.applications.sar.SARTrack;
import gov.nasa.worldwind.applications.sar.SARTrackBuilder;
import gov.nasa.worldwind.applications.sar.TracksPanel;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;

public class TrackController {
    public static final String TRACK_ADD = "TrackController.TrackAdded";
    public static final String TRACK_REMOVE = "TrackController.TrackRemoved";
    public static final String TRACK_MODIFY = "TrackController.TrackModified";
    public static final String TRACK_DISABLE = "TrackController.TrackDisabled";
    public static final String TRACK_ENABLE = "TrackController.TrackEnabled";
    public static final String TRACK_CURRENT = "TrackController.TrackCurrent";
    public static final String TRACK_NAME = "TrackController.TrackName";
    public static final String TRACK_DIRTY_BIT = "TrackController.TrackDirtyBit";
    public static final String BEGIN_TRACK_POINT_ENTRY = "TrackController.BeginTrackPointEntry";
    public static final String END_TRACK_POINT_ENTRY = "TrackController.EndTrackPointEntry";
    private WorldWindow wwd;
    private TracksPanel tracksPanel;
    private AnalysisPanel analysisPanel;
    private HashMap<SARTrack, Layer> trackLayers = new HashMap();
    private SARTrackBuilder trackBuilder = new SARTrackBuilder();

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void setWwd(WorldWindow worldWindow) {
        if (worldWindow == this.wwd) {
            return;
        }
        this.wwd = worldWindow;
        this.trackBuilder.setWwd(this.wwd);
    }

    public TracksPanel getTracksPanel() {
        return this.tracksPanel;
    }

    public void setTracksPanel(TracksPanel tracksPanel) {
        this.tracksPanel = tracksPanel;
    }

    public AnalysisPanel getAnalysisPanel() {
        return this.analysisPanel;
    }

    public void setAnalysisPanel(AnalysisPanel analysisPanel) {
        this.analysisPanel = analysisPanel;
    }

    public void addTrack(SARTrack sARTrack) {
        if (sARTrack == null) {
            return;
        }
        this.createPolylineTrackRepresentation(sARTrack);
        sARTrack.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_REMOVE) {
                    TrackController.this.removeTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_MODIFY) {
                    TrackController.this.updateTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_ENABLE) {
                    TrackController.this.enableTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_DISABLE) {
                    TrackController.this.disableTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_CURRENT) {
                    TrackController.this.trackCurrent((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_NAME) {
                    TrackController.this.trackName((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_DIRTY_BIT) {
                    TrackController.this.trackDirtyBit((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.BEGIN_TRACK_POINT_ENTRY) {
                    TrackController.this.beginTrackPointEntry((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.END_TRACK_POINT_ENTRY) {
                    TrackController.this.endTrackPointEntry((SARTrack)propertyChangeEvent.getSource());
                }
            }
        });
        this.tracksPanel.addTrack(sARTrack);
    }

    public SARTrack getCurrentTrack() {
        return this.tracksPanel.getCurrentTrack();
    }

    public void refreshCurrentTrack() {
        this.trackCurrent(this.getCurrentTrack());
    }

    private void createPolylineTrackRepresentation(SARTrack sARTrack) {
        Polyline polyline = new Polyline(sARTrack);
        polyline.setOffset(sARTrack.getOffset());
        polyline.setPathType(2);
        polyline.setColor(sARTrack.getColor());
        Polyline polyline2 = new Polyline(sARTrack);
        polyline2.setFollowTerrain(true);
        polyline2.setPathType(2);
        polyline2.setColor(sARTrack.getColor());
        polyline2.setStippleFactor(5);
        polyline2.setStipplePattern((short)-21846);
        RenderableLayer renderableLayer = new RenderableLayer();
        renderableLayer.addRenderable(polyline);
        renderableLayer.addRenderable(polyline2);
        this.wwd.getModel().getLayers().add(renderableLayer);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
        this.trackLayers.put(sARTrack, renderableLayer);
    }

    private void removeTrack(SARTrack sARTrack) {
        Layer layer = this.trackLayers.get(sARTrack);
        if (layer == null) {
            return;
        }
        this.trackLayers.remove(sARTrack);
        this.wwd.getModel().getLayers().remove(layer);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void enableTrack(SARTrack sARTrack) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        renderableLayer.setEnabled(true);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void disableTrack(SARTrack sARTrack) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        renderableLayer.setEnabled(false);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void updateTrack(SARTrack sARTrack) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        for (Renderable renderable : renderableLayer.getRenderables()) {
            Polyline polyline = (Polyline)renderable;
            polyline.setPositions(sARTrack);
            if (polyline.isFollowTerrain()) continue;
            polyline.setOffset(sARTrack.getOffset());
        }
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void trackCurrent(SARTrack sARTrack) {
        this.analysisPanel.setCurrentTrack(sARTrack);
        this.trackBuilder.setArmed(false);
    }

    private void trackName(SARTrack sARTrack) {
    }

    private void trackDirtyBit(SARTrack sARTrack) {
    }

    private void beginTrackPointEntry(SARTrack sARTrack) {
        this.trackBuilder.setArmed(false);
        this.trackBuilder.setTrack(sARTrack);
        this.trackBuilder.setArmed(true);
    }

    private void endTrackPointEntry(SARTrack sARTrack) {
        this.trackBuilder.setArmed(false);
    }
}

