/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.applications.sar.SAR2;
import gov.nasa.worldwind.applications.sar.SARPosition;
import gov.nasa.worldwind.applications.sar.SARTrack;
import gov.nasa.worldwind.geom.Angle;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class PositionTable
extends JTable {
    private static final int ITEM_NUM_COLUMN = 0;
    private static final int LATITUDE_COLUMN = 1;
    private static final int LONGITUDE_COLUMN = 2;
    private static final int ALTITUDE_COLUMN = 3;
    private SARTrack sarTrack;
    private String elevationUnit;

    public PositionTable() {
        this.setToolTipText("Track Positions");
        this.setModel(new MyTableModel());
        this.setDefaultRenderer(Double.class, new DoubleCellRenderer("% 7.4f"));
        TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        this.getTableHeader().getColumnModel().getColumn(3).setHeaderRenderer(new AltitudeHeaderRenderer(tableCellRenderer, this));
        this.getColumnModel().getColumn(3).setCellRenderer(new AltitudeCellRenderer("%,8.0f", this));
        TableCellEditor tableCellEditor = this.getDefaultEditor(Double.class);
        this.getColumnModel().getColumn(3).setCellEditor(new AltitudeCellEditor(tableCellEditor, "%f", this));
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setResizable(false);
        tableColumnModel.getColumn(0).setMinWidth(35);
        tableColumnModel.getColumn(0).setPreferredWidth(35);
        tableColumnModel.getColumn(1).setResizable(false);
        tableColumnModel.getColumn(1).setMinWidth(70);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        tableColumnModel.getColumn(2).setResizable(false);
        tableColumnModel.getColumn(2).setMinWidth(70);
        tableColumnModel.getColumn(2).setPreferredWidth(80);
        tableColumnModel.getColumn(3).setResizable(false);
        tableColumnModel.getColumn(3).setMinWidth(70);
        tableColumnModel.getColumn(3).setPreferredWidth(70);
    }

    public SARTrack getSarTrack() {
        return this.sarTrack;
    }

    public void setSarTrack(SARTrack sARTrack) {
        this.sarTrack = sARTrack;
        this.updateTableData();
        this.sarTrack.addPropertyChangeListener("TrackController.TrackModified", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PositionTable.this.updateTableData();
            }
        });
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        this.elevationUnit = string;
    }

    public void updateTableData() {
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    private String makeElevationDescription(String string, double d) {
        String string2 = "Imperial".equals(this.elevationUnit) ? String.format(string, SAR2.metersToFeet(d)) : String.format(string, d);
        return string2;
    }

    private static class AltitudeCellEditor
    implements TableCellEditor {
        private TableCellEditor delegate;
        private final String formatString;
        private PositionTable table;

        public AltitudeCellEditor(TableCellEditor tableCellEditor, String string, PositionTable positionTable) {
            this.delegate = tableCellEditor;
            this.formatString = string;
            this.table = positionTable;
        }

        public Object getCellEditorValue() {
            return this.delegate.getCellEditorValue();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return this.delegate.isCellEditable(eventObject);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return this.delegate.shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            return this.delegate.stopCellEditing();
        }

        public void cancelCellEditing() {
            this.delegate.cancelCellEditing();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.delegate.addCellEditorListener(cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.delegate.removeCellEditorListener(cellEditorListener);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = this.delegate.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (component == null || !(component instanceof JTextComponent)) {
                return component;
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            if (jTextComponent.getText() == null) {
                return component;
            }
            double d = Double.parseDouble(jTextComponent.getText());
            jTextComponent.setText(this.table.makeElevationDescription(this.formatString, d));
            return component;
        }
    }

    private static class AltitudeCellRenderer
    extends DefaultTableCellRenderer {
        private final String formatString;
        private PositionTable table;

        private AltitudeCellRenderer(String string, PositionTable positionTable) {
            this.formatString = string;
            this.table = positionTable;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component == null || !(component instanceof JLabel)) {
                return component;
            }
            JLabel jLabel = (JLabel)component;
            if (jLabel.getText() == null) {
                return component;
            }
            double d = Double.parseDouble(jLabel.getText());
            jLabel.setText(this.table.makeElevationDescription(this.formatString, d));
            jLabel.setHorizontalAlignment(4);
            return component;
        }
    }

    private static class DoubleCellRenderer
    extends DefaultTableCellRenderer {
        private final String formatString;

        public DoubleCellRenderer(String string) {
            this.formatString = string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(component instanceof JLabel)) {
                return component;
            }
            JLabel jLabel = (JLabel)component;
            if (jLabel.getText() == null) {
                return component;
            }
            double d = Double.parseDouble(jLabel.getText());
            jLabel.setText(String.format(this.formatString, d));
            jLabel.setHorizontalAlignment(4);
            return component;
        }
    }

    private static class AltitudeHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegate;
        private PositionTable table;

        public AltitudeHeaderRenderer(TableCellRenderer tableCellRenderer, PositionTable positionTable) {
            this.delegate = tableCellRenderer;
            this.table = positionTable;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.delegate == null) {
                return null;
            }
            Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component == null || !(component instanceof JLabel)) {
                return component;
            }
            JLabel jLabel = (JLabel)component;
            if (jLabel.getText() == null) {
                return component;
            }
            if ("Imperial".equals(this.table.elevationUnit)) {
                jLabel.setText(jLabel.getText() + " (ft)");
            } else {
                jLabel.setText(jLabel.getText() + " (m)");
            }
            return jLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"#", "Latitude\u00b0", "Longitude\u00b0", "Altitude"};
        Class[] columnTypes = new Class[]{Integer.class, Double.class, Double.class, Double.class};
        boolean[] columnEditable = new boolean[]{false, true, true, true};

        @Override
        public Class<?> getColumnClass(int n) {
            return this.columnTypes[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.columnEditable[n2];
        }

        @Override
        public int getRowCount() {
            return PositionTable.this.sarTrack != null ? PositionTable.this.sarTrack.size() : 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (PositionTable.this.sarTrack == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return n;
                }
                case 1: {
                    return ((PositionTable)PositionTable.this).sarTrack.get((int)n).getLatitude().degrees;
                }
                case 2: {
                    return ((PositionTable)PositionTable.this).sarTrack.get((int)n).getLongitude().degrees;
                }
                case 3: {
                    return PositionTable.this.sarTrack.get(n).getElevation();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SARPosition sARPosition;
            if (PositionTable.this.sarTrack == null) {
                return;
            }
            if (!(object instanceof Double)) {
                return;
            }
            double d = (Double)object;
            SARPosition sARPosition2 = PositionTable.this.sarTrack.get(n);
            switch (n2) {
                case 1: {
                    sARPosition = d < -90.0 || d > 90.0 ? sARPosition2 : new SARPosition(Angle.fromDegrees(d), sARPosition2.getLongitude(), sARPosition2.getElevation());
                    break;
                }
                case 2: {
                    sARPosition = d < -180.0 || d > 180.0 ? sARPosition2 : new SARPosition(sARPosition2.getLatitude(), Angle.fromDegrees(d), sARPosition2.getElevation());
                    break;
                }
                case 3: {
                    if ("Imperial".equals(PositionTable.this.elevationUnit)) {
                        d = SAR2.feetToMeters(d);
                    }
                    sARPosition = new SARPosition(sARPosition2.getLatitude(), sARPosition2.getLongitude(), d);
                    break;
                }
                default: {
                    return;
                }
            }
            PositionTable.this.sarTrack.set(n, sARPosition);
        }
    }
}

