/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.applications.sar.LicenseDialog;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.logging.Level;

public class LicenseAgreement
extends WWObjectImpl {
    private final Object license;
    private final String licenseKey;
    public static final String LICENSE_KEY_CACHE_NAME = "gov.nasa.worldwind.avkey.DataCacheNameKey";
    public static final String LICENSE_CONTENT_TYPE = "gov.nasa.worldwind.ContentType";
    public static final String DIALOG_PREFERRED_SIZE = "gov.nasa.worldwind.PreferredSize";
    public static final String DIALOG_TITLE = "gov.nasa.worldwind.avkey.Title";
    private static final String DEFAULT_LICENSE_KEY_CACHE_NAME = "license";
    private static final String DEFAULT_LICENSE_CONTENT_TYPE = "text/plain";
    private static final String DEFAULT_DIALOG_TITLE = "License Agreement";
    public static final String LICENSE_ACCEPTED = "gov.nasa.worldwind.LicenseAccepted";
    public static final String LICENSE_ACCEPTED_AND_INSTALLED = "gov.nasa.worldwind.LicenseAcceptedAndInstalled";
    public static final String LICENSE_DECLINED = "gov.nasa.worldwind.LicenseDeclined";

    public LicenseAgreement(Object object, String string) {
        this(object, string, null);
    }

    public LicenseAgreement(Object object, String string, AVList aVList) {
        if (object == null) {
            String string2 = "nullValue.licenseIsNull";
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = "nullValue.licenseKeyIsNull";
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.license = object;
        this.licenseKey = string;
        if (aVList != null) {
            this.setValues(aVList);
        }
    }

    public final Object getLicense() {
        return this.license;
    }

    public final String getLicenseKey() {
        return this.licenseKey;
    }

    public String checkForLicenseAgreement(Component component) {
        if (this.isLicenseInstalled()) {
            return LICENSE_ACCEPTED_AND_INSTALLED;
        }
        int n = this.displayLicenseAgreement(component);
        if (n == 2) {
            return LICENSE_DECLINED;
        }
        if (n == 1) {
            this.installLicenseKey();
        }
        return this.isLicenseInstalled() ? LICENSE_ACCEPTED_AND_INSTALLED : LICENSE_ACCEPTED;
    }

    public int displayLicenseAgreement(Component component) {
        String string = LicenseAgreement.getStringValue(this, LICENSE_CONTENT_TYPE, DEFAULT_LICENSE_CONTENT_TYPE);
        Object object = this.getValue(DIALOG_PREFERRED_SIZE);
        String string2 = LicenseAgreement.getStringValue(this, DIALOG_TITLE, DEFAULT_DIALOG_TITLE);
        LicenseDialog licenseDialog = new LicenseDialog(this.license);
        licenseDialog.setContentType(string);
        licenseDialog.setTitle(string2);
        if (object != null && object instanceof Dimension) {
            licenseDialog.setPreferredSize((Dimension)object);
        }
        return licenseDialog.showDialog(component);
    }

    public boolean isLicenseInstalled() {
        File file = this.getLicenseKeyFile();
        return file != null && file.exists();
    }

    private void installLicenseKey() {
        File file = this.getLicenseKeyFile();
        try {
            if (file != null) {
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            String string = "Exception while installing license key file";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    private File getLicenseKeyFile() {
        File file = null;
        try {
            String string = LicenseAgreement.getStringValue(this, LICENSE_KEY_CACHE_NAME, DEFAULT_LICENSE_KEY_CACHE_NAME);
            String string2 = WWIO.formPath(string, this.licenseKey);
            file = WorldWind.getDataFileCache().newFile(string2);
        }
        catch (Exception exception) {
            String string = "Exception while searching license key file";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
        return file;
    }
}

