/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class LayerMenu
extends JMenu {
    private WorldWindow wwd;

    public LayerMenu() {
        super("Layers");
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void setWwd(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        for (Layer layer : this.wwd.getModel().getLayers()) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new LayerVisibilityAction(this.wwd, layer));
            jCheckBoxMenuItem.setState(layer.isEnabled());
            this.add(jCheckBoxMenuItem);
        }
    }

    private static class LayerVisibilityAction
    extends AbstractAction {
        private final Layer layer;
        private final WorldWindow wwd;

        public LayerVisibilityAction(WorldWindow worldWindow, Layer layer) {
            super(layer.getName());
            this.layer = layer;
            this.wwd = worldWindow;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.layer.setEnabled(((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            this.wwd.redraw();
        }
    }
}

