/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.util.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementParser {
    protected final String elementName;
    protected ElementParser currentElement = null;
    protected String currentCharacters = null;

    protected ElementParser(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ElementNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.elementName = string;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.URIIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            String string5 = Logging.getMessage("nullValue.LNameIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string3 == null) {
            String string6 = Logging.getMessage("nullValue.QNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (attributes == null) {
            String string7 = Logging.getMessage("nullValue.org.xml.sax.AttributesIsNull");
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        if (this.currentElement != null) {
            this.currentElement.startElement(string, string2, string3, attributes);
        } else {
            this.doStartElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.URIIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            String string5 = Logging.getMessage("nullValue.LNameIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string3 == null) {
            String string6 = Logging.getMessage("nullValue.QNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (this.currentElement != null) {
            this.currentElement.endElement(string, string2, string3);
            if (string2.equalsIgnoreCase(this.currentElement.elementName)) {
                this.currentElement = null;
            }
        }
        this.doEndElement(string, string2, string3);
        this.currentCharacters = null;
    }

    protected void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
    }

    protected void doEndElement(String string, String string2, String string3) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (cArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (cArray.length < 1) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", cArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n + n2 > cArray.length) {
            String string = Logging.getMessage("generic.indexOutOfRange", n + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.currentElement != null) {
            this.currentElement.characters(cArray, n, n2);
        } else {
            this.currentCharacters = this.currentCharacters != null ? this.currentCharacters + new String(cArray, n, n2) : new String(cArray, n, n2);
        }
    }
}

