/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.geotools.renderer.shape.AbstractShape;
import org.geotools.renderer.shape.SimpleGeometry;

public class MultiLineShape
extends AbstractShape
implements Shape {
    public MultiLineShape(SimpleGeometry geom) {
        super(geom);
    }

    public PathIterator getPathIterator(final AffineTransform at) {
        return new PathIterator(){
            int currentPart = 0;
            int currentIndex = 0;

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.currentPart == MultiLineShape.this.geom.coords.length;
            }

            public void next() {
                if (this.isDone()) {
                    return;
                }
                if (this.currentIndex + 1 >= MultiLineShape.this.geom.coords[this.currentPart].length) {
                    this.currentIndex = 0;
                    ++this.currentPart;
                } else {
                    ++this.currentIndex;
                }
            }

            public int currentSegment(float[] coords) {
                if (this.currentIndex == 0) {
                    coords[0] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                    ++this.currentIndex;
                    coords[1] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                    if (at != null) {
                        at.transform(coords, 0, coords, 0, 1);
                    }
                    return 0;
                }
                coords[0] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                ++this.currentIndex;
                coords[1] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return 1;
            }

            public int currentSegment(double[] coords) {
                if (this.currentIndex == 0) {
                    coords[0] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                    ++this.currentIndex;
                    coords[1] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                    if (at != null) {
                        at.transform(coords, 0, coords, 0, 1);
                    }
                    return 0;
                }
                coords[0] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                ++this.currentIndex;
                coords[1] = (float)MultiLineShape.this.geom.coords[this.currentPart][this.currentIndex];
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return 1;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

