/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeneralizedStripFlags;
import javax.media.j3d.J3dI18N;

class GeneralizedStrip {
    private static final boolean debug = false;
    private static final int CW = 0;
    private static final int CCW = 1;
    private static final int RESTART_CW = 0;
    private static final int RESTART_CCW = 1;
    private static final int REPLACE_MIDDLE = 2;
    private static final int REPLACE_OLDEST = 3;

    GeneralizedStrip() {
    }

    static StripArray[] toStripsAndFans(GeneralizedStripFlags generalizedStripFlags, int n) {
        int n2 = generalizedStripFlags.getFlagCount();
        IntList intList = new IntList(n2 * 3);
        IntList intList2 = new IntList(n2 * 3);
        IntList intList3 = new IntList(n2);
        IntList intList4 = new IntList(n2);
        GeneralizedStrip.toStripsAndFans(generalizedStripFlags, n, intList, intList3, intList2, intList4);
        StripArray[] stripArrayArray = new StripArray[2];
        if (intList3.count > 0) {
            stripArrayArray[0] = new StripArray(intList, intList3);
        }
        if (intList4.count > 0) {
            stripArrayArray[1] = new StripArray(intList2, intList4);
        }
        return stripArrayArray;
    }

    private static void toStripsAndFans(GeneralizedStripFlags generalizedStripFlags, int n, IntList intList, IntList intList2, IntList intList3, IntList intList4) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 3;
        int n4 = generalizedStripFlags.getFlag(0);
        int n5 = n4 == 0 ? 0 : 1;
        int n6 = 3;
        int n7 = generalizedStripFlags.getFlagCount();
        if (n6 < n7) {
            n4 = generalizedStripFlags.getFlag(n6);
        }
        while (n6 < n7) {
            int n8 = generalizedStripFlags.getFlag(n6);
            if (n8 == n4 && n8 != 0 && n8 != 1) {
                ++n3;
                ++n6;
                continue;
            }
            if (n4 == 2) {
                GeneralizedStrip.addFan(intList3, intList4, n2, n3, n, n5, bl);
            } else {
                GeneralizedStrip.addStrip(intList, intList2, n2, n3, n, n5);
            }
            if (n8 == 0 || n8 == 1) {
                n5 = n8 == 0 ? 0 : 1;
                n2 = n6;
                n3 = 3;
                bl = false;
                if ((n6 += 3) >= n7) continue;
                n4 = generalizedStripFlags.getFlag(n6);
                continue;
            }
            if (n8 == 3) {
                n5 = n5 == 0 ? 1 : 0;
                n2 = n6 - 2;
                n3 = 3;
            } else {
                if ((n3 & 1) == 0) {
                    n5 = n5 == 0 ? 1 : 0;
                }
                n2 = n6 - 3;
                n3 = 4;
            }
            ++n6;
            bl = true;
            n4 = n8;
        }
        if (n6 == n7) {
            if (n4 == 2) {
                GeneralizedStrip.addFan(intList3, intList4, n2, n3, n, n5, bl);
            } else {
                GeneralizedStrip.addStrip(intList, intList2, n2, n3, n, n5);
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("GeneralizedStrip0"));
        }
    }

    private static void addStrip(IntList intList, IntList intList2, int n, int n2, int n3, int n4) {
        block4: {
            int n5;
            block6: {
                block5: {
                    block3: {
                        n5 = n;
                        if (n4 != n3) break block3;
                        intList2.add(n2);
                        while (n5 < n + n2) {
                            intList.add(n5++);
                        }
                        break block4;
                    }
                    if ((n2 & 1) != 1) break block5;
                    intList2.add(n2);
                    n5 += n2 - 1;
                    while (n5 >= n) {
                        intList.add(n5--);
                    }
                    break block4;
                }
                if (n2 != 4) break block6;
                intList2.add(4);
                intList.add(n5);
                intList.add(n5 + 2);
                intList.add(n5 + 1);
                intList.add(n5 + 3);
                break block4;
            }
            intList2.add(3);
            intList.add(n5);
            intList.add(n5 + 2);
            intList.add(n5 + 1);
            if (n2 <= 3) break block4;
            ++n5;
            intList2.add(n2 - 1);
            while (n5 < n + n2) {
                intList.add(n5++);
            }
        }
    }

    private static void addFan(IntList intList, IntList intList2, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n;
        intList.add(n5++);
        if (n4 == n3) {
            if (bl) {
                intList2.add(n2 - 1);
                ++n5;
            } else {
                intList2.add(n2);
                intList.add(n5++);
            }
            while (n5 < n + n2) {
                intList.add(n5++);
            }
        } else {
            n5 += n2 - 2;
            while (n5 > n + 1) {
                intList.add(n5--);
            }
            if (bl) {
                intList2.add(n2 - 1);
            } else {
                intList2.add(n2);
                intList.add(n5);
            }
        }
    }

    static StripArray toTriangleStrips(GeneralizedStripFlags generalizedStripFlags, int n) {
        int n2 = generalizedStripFlags.getFlagCount();
        IntList intList = new IntList(n2 * 3);
        IntList intList2 = new IntList(n2 * 3);
        IntList intList3 = new IntList(n2);
        IntList intList4 = new IntList(n2);
        GeneralizedStrip.toStripsAndFans(generalizedStripFlags, n, intList, intList3, intList2, intList4);
        if (intList4.count == 0) {
            if (intList3.count > 0) {
                return new StripArray(intList, intList3);
            }
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < intList4.count) {
            GeneralizedStrip.fanToStrips(n3, intList4.ints[n4], intList2.ints, intList, intList3, false);
            n3 += intList4.ints[n4];
            ++n4;
        }
        StripArray stripArray = new StripArray(intList, intList3);
        return stripArray;
    }

    private static void fanToStrips(int n, int n2, int[] nArray, IntList intList, IntList intList2, boolean bl) {
        if (bl) {
            intList2.add(n2);
            intList.add(nArray[n]);
            int n3 = n + 1;
            int n4 = n + (n2 - 1);
            while (n3 <= n4) {
                intList.add(nArray[n3++]);
                if (n3 <= n4) {
                    intList.add(nArray[n4--]);
                    continue;
                }
                break;
            }
        } else {
            int n5 = n++;
            while (n + 4 <= n5 + n2) {
                intList.add(nArray[n]);
                intList.add(nArray[n + 1]);
                intList.add(nArray[n5]);
                intList.add(nArray[n + 2]);
                intList.add(nArray[n + 3]);
                intList2.add(5);
                n += 3;
            }
            if (n + 1 < n5 + n2) {
                intList.add(nArray[n]);
                intList.add(nArray[n + 1]);
                intList.add(nArray[n5]);
                if (++n + 1 < n5 + n2) {
                    intList.add(nArray[n + 1]);
                    intList2.add(4);
                } else {
                    intList2.add(3);
                }
            }
        }
    }

    static int[] toTriangles(GeneralizedStripFlags generalizedStripFlags, int n) {
        int n2 = 0;
        StripArray[] stripArrayArray = GeneralizedStrip.toStripsAndFans(generalizedStripFlags, n);
        if (stripArrayArray[0] != null) {
            n2 = 3 * GeneralizedStrip.getTriangleCount(stripArrayArray[0].stripCounts);
        }
        if (stripArrayArray[1] != null) {
            n2 += 3 * GeneralizedStrip.getTriangleCount(stripArrayArray[1].stripCounts);
        }
        int n3 = 0;
        int[] nArray = new int[n2];
        if (stripArrayArray[0] != null) {
            n3 = GeneralizedStrip.stripsToTriangles(n3, nArray, 0, stripArrayArray[0].vertices.ints, 0, stripArrayArray[0].stripCounts.ints, stripArrayArray[0].stripCounts.count);
        }
        if (stripArrayArray[1] != null) {
            n3 = GeneralizedStrip.fansToTriangles(n3, nArray, 0, stripArrayArray[1].vertices.ints, 0, stripArrayArray[1].stripCounts.ints, stripArrayArray[1].stripCounts.count);
        }
        return nArray;
    }

    private static int stripsToTriangles(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < nArray3[n7 + n3] - 2) {
                if ((n8 & 1) == 0) {
                    nArray[n5 * 3 + 0] = nArray2[n6 + 0];
                    nArray[n5 * 3 + 1] = nArray2[n6 + 1];
                    nArray[n5 * 3 + 2] = nArray2[n6 + 2];
                } else {
                    nArray[n5 * 3 + 0] = nArray2[n6 + 1];
                    nArray[n5 * 3 + 1] = nArray2[n6 + 0];
                    nArray[n5 * 3 + 2] = nArray2[n6 + 2];
                }
                ++n5;
                ++n6;
                ++n8;
            }
            n6 += 2;
            ++n7;
        }
        return n5;
    }

    private static int fansToTriangles(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < nArray3[n7 + n3] - 2) {
                nArray[n5 * 3 + 0] = nArray2[n6];
                nArray[n5 * 3 + 1] = nArray2[n6 + n8 + 1];
                nArray[n5 * 3 + 2] = nArray2[n6 + n8 + 2];
                ++n5;
                ++n8;
            }
            n6 += nArray3[n7 + n3];
            ++n7;
        }
        return n5;
    }

    static StripArray[] toStripsAndTriangles(GeneralizedStripFlags generalizedStripFlags, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        StripArray[] stripArrayArray = new StripArray[2];
        StripArray stripArray = GeneralizedStrip.toTriangleStrips(generalizedStripFlags, n);
        int n8 = 0;
        while (n8 < stripArray.stripCounts.count) {
            if (stripArray.stripCounts.ints[n8] <= n2) {
                ++n6;
                n7 += stripArray.stripCounts.ints[n8] - 2;
            } else {
                ++n4;
                n5 += stripArray.stripCounts.ints[n8];
            }
            ++n8;
        }
        if (n6 <= n3) {
            stripArrayArray[0] = stripArray;
            stripArrayArray[1] = null;
        } else {
            int n9 = 0;
            int[] nArray = new int[n5];
            int n10 = 0;
            int[] nArray2 = new int[n4];
            int n11 = 0;
            int[] nArray3 = new int[3 * n7];
            int n12 = 0;
            int n13 = 0;
            while (n13 < stripArray.stripCounts.count) {
                if (stripArray.stripCounts.ints[n13] <= n2) {
                    n11 = GeneralizedStrip.stripsToTriangles(n11, nArray3, n12, stripArray.vertices.ints, n13, stripArray.stripCounts.ints, 1);
                    n12 += stripArray.stripCounts.ints[n13];
                } else {
                    nArray2[n10++] = stripArray.stripCounts.ints[n13];
                    int n14 = 0;
                    while (n14 < stripArray.stripCounts.ints[n13]) {
                        nArray[n9++] = stripArray.vertices.ints[n12++];
                        ++n14;
                    }
                }
                ++n13;
            }
            stripArrayArray[0] = n4 > 0 ? new StripArray(new IntList(nArray), new IntList(nArray2)) : null;
            stripArrayArray[1] = new StripArray(new IntList(nArray3), null);
        }
        return stripArrayArray;
    }

    static StripArray toLineStrips(GeneralizedStripFlags generalizedStripFlags) {
        int n;
        int n2 = 0;
        int n3 = 2;
        int n4 = generalizedStripFlags.getFlagCount();
        IntList intList = new IntList(n4 * 2);
        IntList intList2 = new IntList(n4);
        int n5 = 2;
        while (n5 < n4) {
            int n6 = generalizedStripFlags.getFlag(n5);
            if (n6 != 0 && n6 != 1) {
                ++n3;
                ++n5;
                continue;
            }
            intList2.add(n3);
            n = n2;
            while (n < n2 + n3) {
                intList.add(n);
                ++n;
            }
            n2 = n5;
            n3 = 2;
            n5 += 2;
        }
        if (n5 == n4) {
            intList2.add(n3);
            n = n2;
            while (n < n2 + n3) {
                intList.add(n);
                ++n;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("GeneralizedStrip0"));
        }
        if (intList2.count > 0) {
            return new StripArray(intList, intList2);
        }
        return null;
    }

    static int getLineCount(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2] - 1;
            ++n2;
        }
        return n;
    }

    static int getTriangleCount(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2] - 2;
            ++n2;
        }
        return n;
    }

    static int getTriangleCount(IntList intList) {
        int n = 0;
        int n2 = 0;
        while (n2 < intList.count) {
            n += intList.ints[n2] - 2;
            ++n2;
        }
        return n;
    }

    static int[] stripsToTriangles(int[] nArray) {
        int n = GeneralizedStrip.getTriangleCount(nArray);
        int[] nArray2 = new int[3 * n];
        IntList intList = new IntList(n + 2 * nArray.length);
        intList.fillAscending();
        GeneralizedStrip.stripsToTriangles(0, nArray2, 0, intList.ints, 0, nArray, nArray.length);
        return nArray2;
    }

    static int[] fansToTriangles(int[] nArray) {
        int n = GeneralizedStrip.getTriangleCount(nArray);
        int[] nArray2 = new int[3 * n];
        IntList intList = new IntList(n + 2 * nArray.length);
        intList.fillAscending();
        GeneralizedStrip.fansToTriangles(0, nArray2, 0, intList.ints, 0, nArray, nArray.length);
        return nArray2;
    }

    static StripArray fanToStrips(int n, int n2, int[] nArray, boolean bl) {
        IntList intList = new IntList(n2 * 3);
        IntList intList2 = new IntList(n2);
        GeneralizedStrip.fanToStrips(n, n2, nArray, intList, intList2, bl);
        return new StripArray(intList, intList2);
    }

    static class StripArray {
        IntList vertices;
        IntList stripCounts;

        StripArray(IntList intList, IntList intList2) {
            this.vertices = intList;
            this.stripCounts = intList2;
        }
    }

    static class IntList {
        int[] ints;
        int count;

        IntList(int n) {
            this.ints = new int[n];
            this.count = 0;
        }

        IntList(int[] nArray) {
            this.ints = nArray;
            this.count = nArray.length;
        }

        void add(int n) {
            if (this.count == this.ints.length) {
                int[] nArray = new int[2 * this.count];
                System.arraycopy(this.ints, 0, nArray, 0, this.count);
                this.ints = nArray;
            }
            this.ints[this.count++] = n;
        }

        int[] trim() {
            if (this.count != this.ints.length) {
                int[] nArray = new int[this.count];
                System.arraycopy(this.ints, 0, nArray, 0, this.count);
                this.ints = nArray;
            }
            return this.ints;
        }

        void fillAscending() {
            int n = 0;
            while (n < this.ints.length) {
                this.ints[n] = n;
                ++n;
            }
            this.count = this.ints.length;
        }

        public String toString() {
            String string = new String("[");
            int n = 0;
            while (n < this.count - 1) {
                string = string + Integer.toString(this.ints[n]) + ", ";
                ++n;
            }
            return string + Integer.toString(this.ints[this.count - 1]) + "]";
        }
    }
}

