/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;

public class ASTTransformationCollectorCodeVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;
    private ClassNode classNode;
    private GroovyClassLoader transformLoader;

    public ASTTransformationCollectorCodeVisitor(SourceUnit source, GroovyClassLoader transformLoader) {
        this.source = source;
        this.transformLoader = transformLoader;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitClass(ClassNode klassNode) {
        ClassNode oldClass = this.classNode;
        this.classNode = klassNode;
        super.visitClass(this.classNode);
        this.classNode = oldClass;
    }

    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode annotation : node.getAnnotations()) {
            Annotation transformClassAnnotation = ASTTransformationCollectorCodeVisitor.getTransformClassAnnotation(annotation.getClassNode());
            if (transformClassAnnotation == null) continue;
            for (String transformClass : this.getTransformClasses(transformClassAnnotation)) {
                try {
                    Class klass = this.transformLoader.loadClass(transformClass, false, true, false);
                    if (ASTTransformation.class.isAssignableFrom(klass)) {
                        this.classNode.addTransform(klass, annotation);
                        continue;
                    }
                    this.source.getErrorCollector().addError(new SimpleMessage("Not an ASTTransformation: " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
                }
                catch (ClassNotFoundException e) {
                    this.source.getErrorCollector().addErrorAndContinue(new SimpleMessage("Could not find class for Transformation Processor " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
                }
            }
        }
    }

    private static Annotation getTransformClassAnnotation(ClassNode annotatedType) {
        if (!annotatedType.isResolved()) {
            return null;
        }
        for (Annotation ann : annotatedType.getTypeClass().getAnnotations()) {
            if (!ann.annotationType().getName().equals(GroovyASTTransformationClass.class.getName())) continue;
            return ann;
        }
        return null;
    }

    private String[] getTransformClasses(Annotation transformClassAnnotation) {
        try {
            Method valueMethod = transformClassAnnotation.getClass().getMethod("value", new Class[0]);
            return (String[])valueMethod.invoke((Object)transformClassAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.source.addException(e);
            return new String[0];
        }
    }
}

