/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.shell.util;

import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.util.ANSI;
import org.codehaus.groovy.tools.shell.util.Preferences;

public final class Logger {
    public static IO io;
    public final String name;
    private static final String DEBUG = "DEBUG";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";

    private Logger(String name) {
        assert (name != null);
        this.name = name;
    }

    private void log(String level, Object msg, Throwable cause) throws Exception {
        assert (level != null);
        assert (msg != null);
        if (io == null) {
            io = new IO();
        }
        if (cause == null && msg instanceof Throwable) {
            cause = (Throwable)msg;
            msg = cause.getMessage();
        }
        StringBuffer buff = new StringBuffer();
        int color = 1;
        if (WARN.equals(level) || ERROR.equals(level)) {
            color = 31;
        }
        buff.append(ANSI.Renderer.encode(level, color));
        buff.append(" [");
        buff.append(this.name);
        buff.append("] ");
        buff.append(msg);
        Logger.io.out.println(buff);
        if (cause != null) {
            cause.printStackTrace(Logger.io.out);
        }
        io.flush();
    }

    public boolean isDebugEnabled() {
        return Preferences.verbosity == IO.Verbosity.DEBUG;
    }

    public boolean isDebug() {
        return this.isDebugEnabled();
    }

    public void debug(Object msg) throws Exception {
        if (this.isDebugEnabled()) {
            this.log(DEBUG, msg, null);
        }
    }

    public void debug(Object msg, Throwable cause) throws Exception {
        if (this.isDebugEnabled()) {
            this.log(DEBUG, msg, cause);
        }
    }

    public void warn(Object msg) throws Exception {
        this.log(WARN, msg, null);
    }

    public void warn(Object msg, Throwable cause) throws Exception {
        this.log(WARN, msg, cause);
    }

    public void error(Object msg) throws Exception {
        this.log(ERROR, msg, null);
    }

    public void error(Object msg, Throwable cause) throws Exception {
        this.log(ERROR, msg, cause);
    }

    public static Logger create(Class type) {
        return new Logger(type.getName());
    }

    public static Logger create(Class type, String suffix) {
        return new Logger(type.getName() + "." + suffix);
    }
}

