/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.util.Utilities;
import org.opengis.coverage.Coverage;

public class CoverageCache {
    private static final ThreadGroup CLEANERS = new ThreadGroup("CoverageCache cleaners");
    public static final CoverageCache DEFAULT = new CoverageCache();
    private final Map<Ref, Ref> cache = new HashMap<Ref, Ref>();
    private final ReferenceQueue<Coverage> queue = new ReferenceQueue();
    private final Cleaner cleaner = new Cleaner(this.cache, this.queue);

    public CoverageCache() {
        this.cleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference reference(Coverage coverage) {
        Map<Ref, Ref> map = this.cache;
        synchronized (map) {
            Ref candidate = new Ref(coverage);
            Ref ref = this.cache.get(candidate);
            if (ref == null) {
                ref = candidate;
                this.cache.put(ref, ref);
            }
            return ref.getReference(this.queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Map<Ref, Ref> map = this.cache;
        synchronized (map) {
            this.cleaner.stop = true;
            this.cache.clear();
        }
        super.finalize();
    }

    private static final class Cleaner
    extends Thread {
        private final Map cache;
        private final ReferenceQueue queue;
        volatile boolean stop;

        public Cleaner(Map cache, ReferenceQueue queue) {
            super(CLEANERS, "CoverageCache cleaner #" + CLEANERS.activeCount());
            this.setPriority(8);
            this.setDaemon(true);
            this.cache = cache;
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                Reference ref;
                try {
                    ref = this.queue.remove();
                }
                catch (InterruptedException exception) {
                    continue;
                }
                Map map = this.cache;
                synchronized (map) {
                    Iterator it = this.cache.keySet().iterator();
                    while (it.hasNext()) {
                        if (it.next() != ref) continue;
                        it.remove();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Ref {
        private Object referent;

        public Ref(Coverage referent) {
            this.referent = referent;
        }

        public Coverage getCoverage() {
            if (this.referent instanceof Reference) {
                return (Coverage)((Reference)this.referent).get();
            }
            return (Coverage)this.referent;
        }

        public Reference getReference(ReferenceQueue<Coverage> queue) {
            if (this.referent instanceof Coverage) {
                Coverage coverage = (Coverage)this.referent;
                this.referent = new WeakReference<Coverage>(coverage, queue);
            }
            return (Reference)this.referent;
        }

        public int hashCode() {
            return this.getCoverage().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Ref && Utilities.equals((Object)this.getCoverage(), (Object)((Ref)object).getCoverage());
        }
    }
}

