/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import org.geonames.InvalidParameterException;
import org.geonames.Style;

public class PostalCodeSearchCriteria {
    private String postalCode;
    private String placeName;
    private String adminCode1;
    private String countryCode;
    private String countryBias;
    private Double latitude;
    private Double longitude;
    private double radius;
    private Style style;
    private int maxRows;
    private int startRow;
    private boolean isOROperator = false;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String string) throws InvalidParameterException {
        if (string != null && string.length() != 2) {
            throw new InvalidParameterException("invalid country code " + string);
        }
        this.countryCode = string;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d) throws InvalidParameterException {
        if (d > 90.0 || d < -90.0) {
            throw new InvalidParameterException("invalid latitude " + d);
        }
        this.latitude = new Double(d);
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d) throws InvalidParameterException {
        if (d > 180.0 || d < -180.0) {
            throw new InvalidParameterException("invalid longitude " + d);
        }
        this.longitude = new Double(d);
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public void setPlaceName(String string) {
        this.placeName = string;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String string) {
        this.postalCode = string;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setOROperator(boolean bl) {
        this.isOROperator = bl;
    }

    public boolean isOROperator() {
        return this.isOROperator;
    }

    public String getAdminCode1() {
        return this.adminCode1;
    }

    public void setAdminCode1(String string) {
        this.adminCode1 = string;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public double getRadius() {
        return this.radius;
    }

    public String getCountryBias() {
        return this.countryBias;
    }

    public void setCountryBias(String string) {
        this.countryBias = string;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int n) {
        this.startRow = n;
    }
}

