/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import javax.swing.event.EventListenerList;
import org.geotools.gui.swing.event.SelectionChangeListener;
import org.geotools.gui.swing.event.SelectionChangedEvent;
import org.geotools.map.MapLayer;
import org.opengis.filter.Filter;

public class SelectionManager {
    EventListenerList listeners = new EventListenerList();
    MapLayer selectionLayer;

    public SelectionManager(MapLayer layer) {
        this.setSelectionLayer(layer);
    }

    public void addSelectionChangeListener(SelectionChangeListener l) {
        this.listeners.add(SelectionChangeListener.class, l);
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        this.listeners.remove(SelectionChangeListener.class, l);
    }

    public void selectionChanged(Object source, Filter filter) {
        SelectionChangeListener[] l = (SelectionChangeListener[])this.listeners.getListeners(SelectionChangeListener.class);
        SelectionChangedEvent ev = new SelectionChangedEvent(source, filter);
        for (int i = 0; i < l.length; ++i) {
            l[i].selectionChanged(ev);
        }
    }

    public MapLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public void setSelectionLayer(MapLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }
}

