/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.nio.Buffer;
import java.util.Arrays;

public class NativePointerObject {
    private long nativePointer;
    private long byteOffset;
    private Buffer buffer;
    private NativePointerObject[] pointers;

    NativePointerObject() {
        this.buffer = null;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    NativePointerObject(Buffer buffer) {
        this.buffer = buffer;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    NativePointerObject(NativePointerObject[] pointers) {
        this.buffer = null;
        this.pointers = pointers;
        this.byteOffset = 0L;
    }

    NativePointerObject(NativePointerObject other) {
        this.buffer = other.buffer;
        this.pointers = other.pointers;
        this.byteOffset = other.byteOffset;
    }

    NativePointerObject(NativePointerObject other, long byteOffset) {
        this(other);
        this.byteOffset += byteOffset;
    }

    long getNativePointer() {
        return this.nativePointer;
    }

    long getByteOffset() {
        return this.byteOffset;
    }

    void setBuffer(Buffer buffer) {
        this.buffer = buffer;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    Buffer getBuffer() {
        return this.buffer;
    }

    NativePointerObject withByteOffset(long byteOffset) {
        return new NativePointerObject(this, byteOffset);
    }

    public String toString() {
        if (this.buffer != null) {
            return "NativePointerObject[buffer=" + this.buffer + "," + "byteOffset=" + this.byteOffset + "]";
        }
        if (this.pointers != null) {
            return "NativePointerObject[pointers=" + Arrays.toString(this.pointers) + "," + "byteOffset=" + this.byteOffset + "]";
        }
        return "NativePointerObject[nativePointer=0x" + Long.toHexString(this.getNativePointer()) + "," + "byteOffset=" + this.byteOffset + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buffer == null ? 0 : this.buffer.hashCode());
        result = 31 * result + (int)(this.byteOffset ^ this.byteOffset >>> 32);
        result = 31 * result + (int)(this.nativePointer ^ this.nativePointer >>> 32);
        result = 31 * result + Arrays.hashCode(this.pointers);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NativePointerObject other = (NativePointerObject)obj;
        if (this.buffer == null ? other.buffer != null : !this.buffer.equals(other.buffer)) {
            return false;
        }
        if (this.byteOffset != other.byteOffset) {
            return false;
        }
        if (this.nativePointer != other.nativePointer) {
            return false;
        }
        return Arrays.equals(this.pointers, other.pointers);
    }
}

