/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.util.Locale;

final class LibUtils {
    public static void loadLibrary(String baseName) {
        String libName = LibUtils.createLibName(baseName);
        try {
            System.loadLibrary(libName);
        }
        catch (Throwable t) {
            System.err.println("Error while loading native library \"" + libName + "\" with base name \"" + baseName + "\"");
            System.err.println("Operating system name: " + System.getProperty("os.name"));
            System.err.println("Architecture         : " + System.getProperty("os.arch"));
            System.err.println("Architecture bit size: " + System.getProperty("sun.arch.data.model"));
            System.err.println("Stack trace:");
            t.printStackTrace();
            throw new UnsatisfiedLinkError("Could not load the native library");
        }
    }

    public static String createLibName(String baseName) {
        OSType osType = LibUtils.calculateOS();
        ARCHType archType = LibUtils.calculateArch();
        String libName = baseName;
        libName = String.valueOf(libName) + "-" + osType.toString().toLowerCase(Locale.ENGLISH);
        libName = String.valueOf(libName) + "-" + archType.toString().toLowerCase(Locale.ENGLISH);
        return libName;
    }

    public static OSType calculateOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        assert (osName != null);
        if (osName.startsWith("mac os")) {
            return OSType.APPLE;
        }
        if (osName.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (osName.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osName.startsWith("sun")) {
            return OSType.SUN;
        }
        return OSType.UNKNOWN;
    }

    public static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        assert (osArch != null);
        if (osArch.equals("i386") || osArch.equals("x86") || osArch.equals("i686")) {
            return ARCHType.X86;
        }
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64")) {
            return ARCHType.X86_64;
        }
        if (osArch.equals("ppc") || osArch.equals("powerpc")) {
            return ARCHType.PPC;
        }
        if (osArch.startsWith("ppc")) {
            return ARCHType.PPC_64;
        }
        if (osArch.startsWith("sparc")) {
            return ARCHType.SPARC;
        }
        if (osArch.startsWith("arm")) {
            return ARCHType.ARM;
        }
        if (osArch.startsWith("mips")) {
            return ARCHType.MIPS;
        }
        if (osArch.contains("risc")) {
            return ARCHType.RISC;
        }
        return ARCHType.UNKNOWN;
    }

    private LibUtils() {
    }

    public static enum ARCHType {
        PPC,
        PPC_64,
        SPARC,
        X86,
        X86_64,
        ARM,
        MIPS,
        RISC,
        UNKNOWN;

    }

    public static enum OSType {
        APPLE,
        LINUX,
        SUN,
        WINDOWS,
        UNKNOWN;

    }
}

