/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import ncsa.hdf.view.ViewProperties;

public class UserOptionsDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -8521813136101442590L;
    private final JFrame viewer;
    private String H4toH5Path;
    private JTextField H4toH5Field;
    private JTextField UGField;
    private JTextField workField;
    private JTextField fileExtField;
    private JTextField maxMemberField;
    private JTextField startMemberField;
    private JComboBox fontSizeChoice;
    private JComboBox fontTypeChoice;
    private JComboBox delimiterChoice;
    private JComboBox imageOriginChoice;
    private JComboBox indexBaseChoice;
    private JComboBox choiceTreeView;
    private JComboBox choiceMetaDataView;
    private JComboBox choiceTextView;
    private JComboBox choiceTableView;
    private JComboBox choiceImageView;
    private JComboBox choicePaletteView;
    private String rootDir;
    private String workDir;
    private JCheckBox checkCurrentUserDir;
    private JCheckBox checkAutoContrast;
    private JCheckBox checkConvertEnum;
    private JCheckBox checkShowValues;
    private JButton currentDirButton;
    private JRadioButton checkReadOnly;
    private JRadioButton checkIndexType;
    private JRadioButton checkIndexOrder;
    private JRadioButton checkIndexNative;
    private JRadioButton checkLibVersion;
    private JRadioButton checkReadAll;
    private int fontSize;
    private boolean isFontChanged;
    private boolean isUserGuideChanged;
    private boolean isWorkDirChanged;
    private static String indexType;
    private static String indexOrder;
    private static Vector<String> treeViews;
    private static Vector<String> imageViews;
    private static Vector<String> tableViews;
    private static Vector<String> textViews;
    private static Vector<String> metaDataViews;
    private static Vector<String> paletteViews;

    public UserOptionsDialog(JFrame view, String viewroot) {
        super(view, "User Options", true);
        this.viewer = view;
        this.rootDir = viewroot;
        this.isFontChanged = false;
        this.isUserGuideChanged = false;
        this.isWorkDirChanged = false;
        this.fontSize = ViewProperties.getFontSize();
        this.workDir = ViewProperties.getWorkDir();
        if (this.workDir == null) {
            this.workDir = this.rootDir;
        }
        treeViews = ViewProperties.getTreeViewList();
        metaDataViews = ViewProperties.getMetaDataViewList();
        textViews = ViewProperties.getTextViewList();
        tableViews = ViewProperties.getTableViewList();
        imageViews = ViewProperties.getImageViewList();
        paletteViews = ViewProperties.getPaletteViewList();
        indexType = ViewProperties.getIndexType();
        indexOrder = ViewProperties.getIndexOrder();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(8, 8));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 550 + (ViewProperties.getFontSize() - 12) * 15;
        contentPane.setPreferredSize(new Dimension(w, h));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("General Setting", this.createGeneralOptionPanel());
        tabbedPane.addTab("Default Module", this.createModuleOptionPanel());
        tabbedPane.setSelectedIndex(0);
        JPanel buttonP = new JPanel();
        JButton b = new JButton("   Ok   ");
        b.setActionCommand("Set options");
        b.addActionListener(this);
        buttonP.add(b);
        b = new JButton("Cancel");
        b.setActionCommand("Cancel");
        b.addActionListener(this);
        buttonP.add(b);
        contentPane.add("Center", tabbedPane);
        contentPane.add("South", buttonP);
        Point l = this.getParent().getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.isFontChanged = false;
            this.isUserGuideChanged = false;
            this.isWorkDirChanged = false;
            this.fontSize = ViewProperties.getFontSize();
            this.workDir = ViewProperties.getWorkDir();
            if (this.workDir == null) {
                this.workDir = this.rootDir;
            }
        }
        super.setVisible(b);
    }

    private JPanel createGeneralOptionPanel() {
        JButton b;
        String[] fontSizeChoices = new String[]{"12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "48"};
        this.fontSizeChoice = new JComboBox<String>(fontSizeChoices);
        this.fontSizeChoice.setSelectedItem(String.valueOf(ViewProperties.getFontSize()));
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String fname = ViewProperties.getFontType();
        this.fontTypeChoice = new JComboBox<String>(fontNames);
        boolean isFontValid = false;
        if (fontNames != null) {
            for (int i = 0; i < fontNames.length; ++i) {
                if (!fontNames[i].equalsIgnoreCase(fname)) continue;
                isFontValid = true;
            }
        }
        if (!isFontValid) {
            fname = this.viewer.getFont().getFamily();
            ViewProperties.setFontType(fname);
        }
        this.fontTypeChoice.setSelectedItem(fname);
        String[] delimiterChoices = new String[]{"Tab", "Comma", "Space", "Colon", "Semi-Colon"};
        this.delimiterChoice = new JComboBox<String>(delimiterChoices);
        this.delimiterChoice.setSelectedItem(ViewProperties.getDataDelimiter());
        String[] imageOriginChoices = new String[]{"UpperLeft", "LowerLeft", "UpperRight", "LowerRight"};
        this.imageOriginChoice = new JComboBox<String>(imageOriginChoices);
        this.imageOriginChoice.setSelectedItem(ViewProperties.getImageOrigin());
        JPanel centerP = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.fill = 2;
        centerP.setLayout(new GridBagLayout());
        centerP.setBorder(new SoftBevelBorder(1));
        JPanel p0 = new JPanel();
        p0.setLayout(new BorderLayout());
        this.checkCurrentUserDir = new JCheckBox("\"Current Working Directory\" or", false);
        p0.add((Component)this.checkCurrentUserDir, "West");
        this.checkCurrentUserDir.addActionListener(this);
        this.checkCurrentUserDir.setActionCommand("Set current dir to user.dir");
        this.workField = new JTextField(this.workDir);
        p0.add((Component)this.workField, "Center");
        this.currentDirButton = b = new JButton("Browse...");
        b.setActionCommand("Browse current dir");
        b.addActionListener(this);
        p0.add((Component)b, "East");
        TitledBorder tborder = new TitledBorder("Default Working Directory");
        tborder.setTitleColor(Color.darkGray);
        p0.setBorder(tborder);
        c.gridx = 0;
        c.gridy = 0;
        centerP.add((Component)p0, c);
        p0 = new JPanel();
        p0.setLayout(new BorderLayout());
        p0.add((Component)new JLabel("User's Guide:  "), "West");
        this.UGField = new JTextField(ViewProperties.getUsersGuide());
        p0.add((Component)this.UGField, "Center");
        b = new JButton("Browse...");
        b.setActionCommand("Browse UG");
        b.addActionListener(this);
        p0.add((Component)b, "East");
        tborder = new TitledBorder("Help Document");
        tborder.setTitleColor(Color.darkGray);
        p0.setBorder(tborder);
        c.gridx = 0;
        c.gridy = 1;
        centerP.add((Component)p0, c);
        p0 = new JPanel();
        p0.setLayout(new GridLayout(1, 3, 8, 8));
        JPanel p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        p00.add((Component)new JLabel("Extension: "), "West");
        this.fileExtField = new JTextField(ViewProperties.getFileExtension());
        p00.add((Component)this.fileExtField, "Center");
        tborder = new TitledBorder("File Extension");
        tborder.setTitleColor(Color.darkGray);
        p00.setBorder(tborder);
        JPanel p01 = new JPanel();
        p01.setLayout(new GridLayout(1, 2, 8, 8));
        this.checkReadOnly = new JRadioButton("Read Only", ViewProperties.isReadOnly());
        p01.add(this.checkReadOnly);
        JRadioButton rw = new JRadioButton("Read/Write", !ViewProperties.isReadOnly());
        p01.add(rw);
        ButtonGroup bgrp = new ButtonGroup();
        bgrp.add(this.checkReadOnly);
        bgrp.add(rw);
        tborder = new TitledBorder("Default File Access Mode");
        tborder.setTitleColor(Color.darkGray);
        p01.setBorder(tborder);
        JPanel p02 = new JPanel();
        p02.setLayout(new GridLayout(1, 2, 8, 8));
        this.checkLibVersion = new JRadioButton("Earliest", ViewProperties.isEarlyLib());
        p02.add(this.checkLibVersion);
        JRadioButton latestLib = new JRadioButton("Latest", !ViewProperties.isReadOnly());
        p02.add(latestLib);
        bgrp = new ButtonGroup();
        bgrp.add(this.checkLibVersion);
        bgrp.add(latestLib);
        tborder = new TitledBorder("Default Lib Version");
        tborder.setTitleColor(Color.darkGray);
        p02.setBorder(tborder);
        p0.add(p01);
        p0.add(p00);
        p0.add(p02);
        c.gridx = 0;
        c.gridy = 2;
        centerP.add((Component)p0, c);
        p0 = new JPanel();
        p0.setLayout(new GridLayout(1, 2, 8, 8));
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        p00.add((Component)new JLabel("Font Size:"), "West");
        p00.add((Component)this.fontSizeChoice, "Center");
        p0.add(p00);
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        p00.add((Component)new JLabel("Font Type:"), "West");
        p00.add((Component)this.fontTypeChoice, "Center");
        p0.add(p00);
        tborder = new TitledBorder("Text Font");
        tborder.setTitleColor(Color.darkGray);
        p0.setBorder(tborder);
        c.gridx = 0;
        c.gridy = 3;
        centerP.add((Component)p0, c);
        p0 = new JPanel();
        p0.setLayout(new GridLayout(1, 4, 8, 8));
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        this.checkAutoContrast = new JCheckBox("Autogain Image Contrast");
        this.checkAutoContrast.setSelected(ViewProperties.isAutoContrast());
        p00.add((Component)this.checkAutoContrast, "Center");
        JButton button = new JButton(ViewProperties.getHelpIcon());
        button.setToolTipText("Help on Auto Contrast");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(this);
        button.setActionCommand("Help on Auto Contrast");
        p00.add((Component)button, "West");
        p0.add(p00);
        this.checkShowValues = new JCheckBox("Show Values");
        p0.add(this.checkShowValues);
        this.checkShowValues.setSelected(ViewProperties.showImageValues());
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        p00.add((Component)new JLabel("Image Origin:"), "West");
        p00.add((Component)this.imageOriginChoice, "Center");
        p0.add(p00);
        tborder = new TitledBorder("Image");
        tborder.setTitleColor(Color.darkGray);
        p0.setBorder(tborder);
        c.gridx = 0;
        c.gridy = 4;
        centerP.add((Component)p0, c);
        p0 = new JPanel();
        p0.setLayout(new GridLayout(1, 3, 20, 8));
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        button = new JButton(ViewProperties.getHelpIcon());
        button.setToolTipText("Help on Convert Enum");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(this);
        button.setActionCommand("Help on Convert Enum");
        p00.add((Component)button, "West");
        this.checkConvertEnum = new JCheckBox("Convert Enum");
        this.checkConvertEnum.setSelected(ViewProperties.isConvertEnum());
        p00.add((Component)this.checkConvertEnum, "Center");
        p0.add(p00);
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        String[] indexBaseChoices = new String[]{"0-based", "1-based"};
        this.indexBaseChoice = new JComboBox<String>(indexBaseChoices);
        if (ViewProperties.isIndexBase1()) {
            this.indexBaseChoice.setSelectedIndex(1);
        } else {
            this.indexBaseChoice.setSelectedIndex(0);
        }
        p00.add((Component)new JLabel("Index Base: "), "West");
        p00.add((Component)this.indexBaseChoice, "Center");
        p0.add(p00);
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        p00.add((Component)new JLabel("Data Delimiter:"), "West");
        p00.add((Component)this.delimiterChoice, "Center");
        p0.add(p00);
        tborder = new TitledBorder("Data");
        tborder.setTitleColor(Color.darkGray);
        p0.setBorder(tborder);
        c.gridx = 0;
        c.gridy = 5;
        centerP.add((Component)p0, c);
        p0 = new JPanel();
        p0.setLayout(new GridLayout(1, 3, 8, 8));
        int nMax = ViewProperties.getMaxMembers();
        this.checkReadAll = new JRadioButton("Open All", nMax <= 0 || nMax == Integer.MAX_VALUE);
        this.checkReadAll.addItemListener(this);
        p0.add(this.checkReadAll);
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        p00.add((Component)new JLabel("Start Member: "), "West");
        this.startMemberField = new JTextField(String.valueOf(ViewProperties.getStartMembers()));
        p00.add((Component)this.startMemberField, "Center");
        p0.add(p00);
        p00 = new JPanel();
        p00.setLayout(new BorderLayout());
        p00.add((Component)new JLabel("Member Count: "), "West");
        this.maxMemberField = new JTextField(String.valueOf(ViewProperties.getMaxMembers()));
        p00.add((Component)this.maxMemberField, "Center");
        p0.add(p00);
        this.startMemberField.setEnabled(!this.checkReadAll.isSelected());
        this.maxMemberField.setEnabled(!this.checkReadAll.isSelected());
        tborder = new TitledBorder("Objects to Open");
        tborder.setTitleColor(Color.darkGray);
        p0.setBorder(tborder);
        c.gridx = 0;
        c.gridy = 6;
        centerP.add((Component)p0, c);
        p0 = new JPanel();
        p0.setLayout(new GridLayout(1, 2, 8, 8));
        JPanel pType = new JPanel();
        pType.setLayout(new GridLayout(1, 2, 8, 8));
        this.checkIndexType = new JRadioButton("By Name", indexType.compareTo("H5_INDEX_NAME") == 0);
        pType.add(this.checkIndexType);
        JRadioButton checkIndexCreateOrder = new JRadioButton("By Creation Order", indexType.compareTo("H5_INDEX_CRT_ORDER") == 0);
        pType.add(checkIndexCreateOrder);
        ButtonGroup bTypegrp = new ButtonGroup();
        bTypegrp.add(this.checkIndexType);
        bTypegrp.add(checkIndexCreateOrder);
        tborder = new TitledBorder("Indexing Type");
        tborder.setTitleColor(Color.darkGray);
        pType.setBorder(tborder);
        p0.add(pType);
        JPanel pOrder = new JPanel();
        pOrder.setLayout(new GridLayout(1, 3, 8, 8));
        this.checkIndexOrder = new JRadioButton("Increments", indexOrder.compareTo("H5_ITER_INC") == 0);
        pOrder.add(this.checkIndexOrder);
        JRadioButton checkIndexDecrement = new JRadioButton("Decrements", indexOrder.compareTo("H5_ITER_DEC") == 0);
        pOrder.add(checkIndexDecrement);
        this.checkIndexNative = new JRadioButton("Native", indexOrder.compareTo("H5_ITER_NATIVE") == 0);
        pOrder.add(this.checkIndexNative);
        ButtonGroup bOrdergrp = new ButtonGroup();
        bOrdergrp.add(this.checkIndexOrder);
        bOrdergrp.add(checkIndexDecrement);
        bOrdergrp.add(this.checkIndexNative);
        tborder = new TitledBorder("Indexing Order");
        tborder.setTitleColor(Color.darkGray);
        pOrder.setBorder(tborder);
        p0.add(pOrder);
        tborder = new TitledBorder("Display Indexing Options");
        tborder.setTitleColor(Color.darkGray);
        p0.setBorder(tborder);
        c.gridx = 0;
        c.gridy = 7;
        centerP.add((Component)p0, c);
        if (this.workDir.equals(System.getProperty("user.dir"))) {
            this.checkCurrentUserDir.setSelected(true);
            this.workField.setEnabled(false);
        }
        return centerP;
    }

    private JPanel createModuleOptionPanel() {
        this.choiceTreeView = new JComboBox<String>(treeViews);
        this.choiceTableView = new JComboBox<String>(tableViews);
        this.choiceTextView = new JComboBox<String>(textViews);
        this.choiceImageView = new JComboBox<String>(imageViews);
        this.choiceMetaDataView = new JComboBox<String>(metaDataViews);
        this.choicePaletteView = new JComboBox<String>(paletteViews);
        JPanel moduleP = new JPanel();
        moduleP.setLayout(new GridLayout(6, 1, 10, 10));
        moduleP.setBorder(new SoftBevelBorder(1));
        JPanel treeP = new JPanel();
        TitledBorder tborder = new TitledBorder("TreeView");
        tborder.setTitleColor(Color.darkGray);
        treeP.setBorder(tborder);
        moduleP.add(treeP);
        treeP.setLayout(new BorderLayout(5, 5));
        treeP.add((Component)this.choiceTreeView, "Center");
        JPanel attrP = new JPanel();
        tborder = new TitledBorder("MetaDataView");
        tborder.setTitleColor(Color.darkGray);
        attrP.setBorder(tborder);
        moduleP.add(attrP);
        attrP.setLayout(new BorderLayout(5, 5));
        attrP.add((Component)this.choiceMetaDataView, "Center");
        JPanel textP = new JPanel();
        tborder = new TitledBorder("TextView");
        tborder.setTitleColor(Color.darkGray);
        textP.setBorder(tborder);
        moduleP.add(textP);
        textP.setLayout(new BorderLayout(5, 5));
        textP.add((Component)this.choiceTextView, "Center");
        JPanel tableP = new JPanel();
        tborder = new TitledBorder("TableView");
        tborder.setTitleColor(Color.darkGray);
        tableP.setBorder(tborder);
        moduleP.add(tableP);
        tableP.setLayout(new BorderLayout(5, 5));
        tableP.add((Component)this.choiceTableView, "Center");
        JPanel imageP = new JPanel();
        tborder = new TitledBorder("ImageView");
        tborder.setTitleColor(Color.darkGray);
        imageP.setBorder(tborder);
        moduleP.add(imageP);
        imageP.setLayout(new BorderLayout(5, 5));
        imageP.add((Component)this.choiceImageView, "Center");
        JPanel palP = new JPanel();
        tborder = new TitledBorder("PaletteView");
        tborder.setTitleColor(Color.darkGray);
        palP.setBorder(tborder);
        moduleP.add(palP);
        palP.setLayout(new BorderLayout(5, 5));
        palP.add((Component)this.choicePaletteView, "Center");
        return moduleP;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Set options")) {
            this.setUserOptions();
            this.setVisible(false);
        } else if (cmd.equals("Cancel")) {
            this.isFontChanged = false;
            this.setVisible(false);
        } else if (cmd.equals("Set current dir to user.dir")) {
            boolean isCheckCurrentUserDirSelected = this.checkCurrentUserDir.isSelected();
            this.workField.setEnabled(!isCheckCurrentUserDirSelected);
            this.currentDirButton.setEnabled(!isCheckCurrentUserDirSelected);
        } else if (cmd.equals("Browse UG")) {
            JFileChooser fchooser = new JFileChooser(this.rootDir);
            int returnVal = fchooser.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            File choosedFile = fchooser.getSelectedFile();
            if (choosedFile == null) {
                return;
            }
            String fname = choosedFile.getAbsolutePath();
            if (fname == null) {
                return;
            }
            this.UGField.setText(fname);
        } else if (cmd.equals("Browse current dir")) {
            JFileChooser fchooser = new JFileChooser(this.rootDir);
            fchooser.setFileSelectionMode(1);
            int returnVal = fchooser.showDialog(this, "Select");
            if (returnVal != 0) {
                return;
            }
            File choosedFile = fchooser.getSelectedFile();
            if (choosedFile == null) {
                return;
            }
            String fname = choosedFile.getAbsolutePath();
            if (fname == null) {
                return;
            }
            this.workField.setText(fname);
        } else if (cmd.equals("Browse h4toh5")) {
            JFileChooser fchooser = new JFileChooser(this.rootDir);
            int returnVal = fchooser.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            File choosedFile = fchooser.getSelectedFile();
            if (choosedFile == null) {
                return;
            }
            String fname = choosedFile.getAbsolutePath();
            if (fname == null) {
                return;
            }
            this.H4toH5Path = fname;
            this.H4toH5Field.setText(fname);
        } else if (cmd.startsWith("Add Module")) {
            String newModule = JOptionPane.showInputDialog(this, "Type the full path of the new module:", cmd, -1);
            if (newModule == null || newModule.length() < 1) {
                return;
            }
            try {
                Class.forName(newModule);
            }
            catch (Exception ex) {
                try {
                    ViewProperties.loadExtClass().loadClass(newModule);
                }
                catch (ClassNotFoundException ex2) {
                    JOptionPane.showMessageDialog(this, "Cannot find module:\n " + newModule + "\nPlease check the module name and classpath.", "HDFView", 0);
                    return;
                }
            }
            if (cmd.endsWith("TreeView") && !treeViews.contains(newModule)) {
                treeViews.add(newModule);
                this.choiceTreeView.addItem(newModule);
            } else if (cmd.endsWith("MetadataView") && !metaDataViews.contains(newModule)) {
                metaDataViews.add(newModule);
                this.choiceMetaDataView.addItem(newModule);
            } else if (cmd.endsWith("TextView") && !textViews.contains(newModule)) {
                textViews.add(newModule);
                this.choiceTextView.addItem(newModule);
            } else if (cmd.endsWith("TableView") && !tableViews.contains(newModule)) {
                tableViews.add(newModule);
                this.choiceTableView.addItem(newModule);
            } else if (cmd.endsWith("ImageView") && !imageViews.contains(newModule)) {
                imageViews.add(newModule);
                this.choiceImageView.addItem(newModule);
            } else if (cmd.endsWith("PaletteView") && !paletteViews.contains(newModule)) {
                paletteViews.add(newModule);
                this.choicePaletteView.addItem(newModule);
            }
        } else if (cmd.startsWith("Delete Module")) {
            JComboBox theChoice = (JComboBox)source;
            if (theChoice.getItemCount() == 1) {
                JOptionPane.showMessageDialog(this, "Cannot delete the last module.", cmd, 0);
                return;
            }
            int reply = JOptionPane.showConfirmDialog(this, "Do you want to delete the selected module?", cmd, 0);
            if (reply == 1) {
                return;
            }
            String moduleName = (String)theChoice.getSelectedItem();
            theChoice.removeItem(moduleName);
            if (cmd.endsWith("TreeView")) {
                treeViews.remove(moduleName);
            } else if (cmd.endsWith("MetadataView")) {
                metaDataViews.remove(moduleName);
            } else if (cmd.endsWith("TextView")) {
                textViews.remove(moduleName);
            } else if (cmd.endsWith("TableView")) {
                tableViews.remove(moduleName);
            } else if (cmd.endsWith("ImageView")) {
                imageViews.remove(moduleName);
            } else if (cmd.endsWith("PaletteView")) {
                paletteViews.remove(moduleName);
            }
        } else if (cmd.equals("Help on Auto Contrast")) {
            String msg = "Auto Contrast does the following to compute a gain/bias \nthat will stretch the pixels in the image to fit the pixel \nvalues of the graphics system. For example, it stretches unsigned\nshort data to fit the full range of an unsigned short. Later \ncode simply takes the high order byte and passes it to the graphics\nsystem (which expects 0-255). It uses some statistics on the pixels \nto prevent outliers from throwing off the gain/bias calculations much.\n\nTo compute the gain/bias we... \nFind the mean and std. deviation of the pixels in the image \nmin = mean - 3 * std.dev. \nmax = mean + 3 * std.dev. \nsmall fudge factor because this tends to overshoot a bit \nStretch to 0-USHRT_MAX \n        gain = USHRT_MAX / (max-min) \n        bias = -min \n\nTo apply the gain/bias to a pixel, use the formula \ndata[i] = (data[i] + bias) * gain \n\n\n\n";
            JOptionPane.showMessageDialog(this, "Auto Contrast does the following to compute a gain/bias \nthat will stretch the pixels in the image to fit the pixel \nvalues of the graphics system. For example, it stretches unsigned\nshort data to fit the full range of an unsigned short. Later \ncode simply takes the high order byte and passes it to the graphics\nsystem (which expects 0-255). It uses some statistics on the pixels \nto prevent outliers from throwing off the gain/bias calculations much.\n\nTo compute the gain/bias we... \nFind the mean and std. deviation of the pixels in the image \nmin = mean - 3 * std.dev. \nmax = mean + 3 * std.dev. \nsmall fudge factor because this tends to overshoot a bit \nStretch to 0-USHRT_MAX \n        gain = USHRT_MAX / (max-min) \n        bias = -min \n\nTo apply the gain/bias to a pixel, use the formula \ndata[i] = (data[i] + bias) * gain \n\n\n\n");
        } else if (cmd.equals("Help on Convert Enum")) {
            String msg = "Convert enum data to strings. \nFor example, a dataset of an enum type of (R=0, G=, B=2) \nhas values of (0, 2, 2, 2, 1, 1). With conversion, the data values are \nshown as (R, B, B, B, G, G).\n\n\n";
            JOptionPane.showMessageDialog(this, "Convert enum data to strings. \nFor example, a dataset of an enum type of (R=0, G=, B=2) \nhas values of (0, 2, 2, 2, 1, 1). With conversion, the data values are \nshown as (R, B, B, B, G, G).\n\n\n");
        }
    }

    private void setUserOptions() {
        String ext;
        String UGPath = this.UGField.getText();
        if (UGPath != null && UGPath.length() > 0) {
            this.isUserGuideChanged = !(UGPath = UGPath.trim()).equals(ViewProperties.getUsersGuide());
            ViewProperties.setUsersGuide(UGPath);
        }
        String workPath = this.workField.getText();
        if (this.checkCurrentUserDir.isSelected()) {
            workPath = "user.dir";
        }
        if (workPath != null && workPath.length() > 0) {
            this.isWorkDirChanged = !(workPath = workPath.trim()).equals(ViewProperties.getWorkDir());
            ViewProperties.setWorkDir(workPath);
        }
        if ((ext = this.fileExtField.getText()) != null && ext.length() > 0) {
            ext = ext.trim();
            ViewProperties.setFileExtension(ext);
        }
        if (this.checkReadOnly.isSelected()) {
            ViewProperties.setReadOnly(true);
        } else {
            ViewProperties.setReadOnly(false);
        }
        if (this.checkLibVersion.isSelected()) {
            ViewProperties.setEarlyLib(true);
        } else {
            ViewProperties.setEarlyLib(false);
        }
        int fsize = 12;
        try {
            fsize = Integer.parseInt((String)this.fontSizeChoice.getSelectedItem());
            ViewProperties.setFontSize(fsize);
            if (this.fontSize != ViewProperties.getFontSize()) {
                this.isFontChanged = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String ftype = (String)this.fontTypeChoice.getSelectedItem();
        if (!ftype.equalsIgnoreCase(ViewProperties.getFontType())) {
            this.isFontChanged = true;
            ViewProperties.setFontType(ftype);
        }
        ViewProperties.setDataDelimiter((String)this.delimiterChoice.getSelectedItem());
        ViewProperties.setImageOrigin((String)this.imageOriginChoice.getSelectedItem());
        if (this.checkIndexType.isSelected()) {
            ViewProperties.setIndexType("H5_INDEX_NAME");
        } else {
            ViewProperties.setIndexType("H5_INDEX_CRT_ORDER");
        }
        if (this.checkIndexOrder.isSelected()) {
            ViewProperties.setIndexOrder("H5_ITER_INC");
        } else if (this.checkIndexNative.isSelected()) {
            ViewProperties.setIndexOrder("H5_ITER_NATIVE");
        } else {
            ViewProperties.setIndexOrder("H5_ITER_DEC");
        }
        if (this.checkReadAll.isSelected()) {
            ViewProperties.setStartMembers(0);
            ViewProperties.setMaxMembers(-1);
        } else {
            try {
                int maxsize = Integer.parseInt(this.maxMemberField.getText());
                ViewProperties.setMaxMembers(maxsize);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                int startsize = Integer.parseInt(this.startMemberField.getText());
                ViewProperties.setStartMembers(startsize);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Vector[] moduleList = new Vector[]{treeViews, metaDataViews, textViews, tableViews, imageViews, paletteViews};
        JComboBox[] choiceList = new JComboBox[]{this.choiceTreeView, this.choiceMetaDataView, this.choiceTextView, this.choiceTableView, this.choiceImageView, this.choicePaletteView};
        for (int i = 0; i < 6; ++i) {
            Object theModule = choiceList[i].getSelectedItem();
            moduleList[i].remove(theModule);
            moduleList[i].add(0, theModule);
        }
        ViewProperties.setAutoContrast(this.checkAutoContrast.isSelected());
        ViewProperties.setShowImageValue(this.checkShowValues.isSelected());
        ViewProperties.setConvertEnum(this.checkConvertEnum.isSelected());
        if (this.indexBaseChoice.getSelectedIndex() == 0) {
            ViewProperties.setIndexBase1(false);
        } else {
            ViewProperties.setIndexBase1(true);
        }
    }

    public boolean isFontChanged() {
        return this.isFontChanged;
    }

    public boolean isUserGuideChanged() {
        return this.isUserGuideChanged;
    }

    public boolean isWorkDirChanged() {
        return this.isWorkDirChanged;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.checkReadAll)) {
            this.startMemberField.setEnabled(!this.checkReadAll.isSelected());
            this.maxMemberField.setEnabled(!this.checkReadAll.isSelected());
        }
    }
}

