/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;
import ncsa.hdf.view.ViewProperties;

public class DefaultFileFilter
extends FileFilter {
    private static FileFilter FILE_FILTER_HDF = null;
    private static FileFilter FILE_FILTER_HDF4 = null;
    private static FileFilter FILE_FILTER_HDF5 = null;
    private static FileFilter FILE_FILTER_JPEG = null;
    private static FileFilter FILE_FILTER_TIFF = null;
    private static FileFilter FILE_FILTER_PNG = null;
    private static FileFilter FILE_FILTER_GIF = null;
    private static FileFilter FILE_FILTER_BMP = null;
    private static FileFilter FILE_FILTER_IMG = null;
    private static FileFilter FILE_FILTER_TEXT = null;
    private static FileFilter FILE_FILTER_BINARY = null;
    private static String fileExtension = ViewProperties.getFileExtension();
    private Hashtable<String, DefaultFileFilter> filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public DefaultFileFilter() {
    }

    public DefaultFileFilter(String extension) {
        this(extension, null);
    }

    public DefaultFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public DefaultFileFilter(String[] filters) {
        this(filters, null);
    }

    public DefaultFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        String ext = null;
        StringTokenizer st = new StringTokenizer(extension, ",");
        while (st.hasMoreElements()) {
            ext = st.nextToken().trim();
            this.filters.put(ext.toLowerCase(), this);
        }
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration<String> extensions = this.filters.keys();
                if (extensions != null) {
                    if (!extensions.hasMoreElements()) {
                        this.fullDescription = null;
                        return null;
                    }
                    this.fullDescription = this.fullDescription + "." + extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", " + extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public static FileFilter getFileFilter() {
        boolean extensionNotChanged = fileExtension.equalsIgnoreCase(ViewProperties.getFileExtension());
        if (FILE_FILTER_HDF != null && extensionNotChanged) {
            return FILE_FILTER_HDF;
        }
        fileExtension = ViewProperties.getFileExtension();
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.setDescription("HDF & more");
        filter.addExtension(fileExtension);
        FILE_FILTER_HDF = filter;
        return FILE_FILTER_HDF;
    }

    public static FileFilter getFileFilterHDF4() {
        if (FILE_FILTER_HDF4 != null) {
            return FILE_FILTER_HDF4;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("hdf");
        filter.addExtension("h4");
        filter.addExtension("hdf4");
        filter.setDescription("HDF4 files");
        FILE_FILTER_HDF4 = filter;
        return FILE_FILTER_HDF4;
    }

    public static FileFilter getFileFilterHDF5() {
        if (FILE_FILTER_HDF5 != null) {
            return FILE_FILTER_HDF5;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("h5");
        filter.addExtension("hdf5");
        filter.setDescription("HDF5 files");
        FILE_FILTER_HDF5 = filter;
        return FILE_FILTER_HDF5;
    }

    public static FileFilter getFileFilterJPEG() {
        if (FILE_FILTER_JPEG != null) {
            return FILE_FILTER_JPEG;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("jpe");
        filter.addExtension("jif");
        filter.addExtension("jfif");
        filter.addExtension("jfi");
        filter.setDescription("JPEG images");
        FILE_FILTER_JPEG = filter;
        return FILE_FILTER_JPEG;
    }

    public static FileFilter getFileFilterTIFF() {
        if (FILE_FILTER_TIFF != null) {
            return FILE_FILTER_TIFF;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("tif");
        filter.addExtension("tiff");
        filter.setDescription("TIFF images");
        FILE_FILTER_TIFF = filter;
        return FILE_FILTER_TIFF;
    }

    public static FileFilter getFileFilterPNG() {
        if (FILE_FILTER_PNG != null) {
            return FILE_FILTER_PNG;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("png");
        filter.setDescription("PNG images");
        FILE_FILTER_PNG = filter;
        return FILE_FILTER_PNG;
    }

    public static FileFilter getFileFilterBMP() {
        if (FILE_FILTER_BMP != null) {
            return FILE_FILTER_BMP;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("bmp");
        filter.addExtension("dib");
        filter.setDescription("BMP images");
        FILE_FILTER_BMP = filter;
        return FILE_FILTER_BMP;
    }

    public static FileFilter getFileFilterGIF() {
        if (FILE_FILTER_GIF != null) {
            return FILE_FILTER_GIF;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("gif");
        filter.setDescription("GIF images");
        FILE_FILTER_GIF = filter;
        return FILE_FILTER_GIF;
    }

    public static FileFilter getImageFileFilter() {
        if (FILE_FILTER_IMG != null) {
            return FILE_FILTER_IMG;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("jpe");
        filter.addExtension("jif");
        filter.addExtension("jfif");
        filter.addExtension("jfi");
        filter.addExtension("png");
        filter.addExtension("gif");
        filter.addExtension("bmp");
        filter.addExtension("dib");
        filter.setDescription("GIF, JPEG, BMP, or PNG images");
        FILE_FILTER_IMG = filter;
        return FILE_FILTER_IMG;
    }

    public static FileFilter getFileFilterText() {
        if (FILE_FILTER_TEXT != null) {
            return FILE_FILTER_TEXT;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("txt");
        filter.addExtension("text");
        filter.setDescription("Text");
        FILE_FILTER_TEXT = filter;
        return FILE_FILTER_TEXT;
    }

    public static FileFilter getFileFilterBinary() {
        if (FILE_FILTER_BINARY != null) {
            return FILE_FILTER_BINARY;
        }
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("bin");
        filter.setDescription("Binary");
        FILE_FILTER_BINARY = filter;
        return FILE_FILTER_BINARY;
    }

    public static boolean isHDF4(String filename) {
        boolean ish4 = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (Exception ex) {
            raf = null;
        }
        if (raf == null) {
            return false;
        }
        byte[] header = new byte[4];
        try {
            raf.read(header);
        }
        catch (Exception ex) {
            header = null;
        }
        if (header != null) {
            ish4 = header[0] == 14 && header[1] == 3 && header[2] == 19 && header[3] == 1;
        }
        try {
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return ish4;
    }

    public static boolean isHDF5(String filename) {
        boolean ish5 = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (Exception ex) {
            raf = null;
        }
        if (raf == null) {
            return false;
        }
        byte[] header = new byte[8];
        long fileSize = 0L;
        try {
            fileSize = raf.length();
        }
        catch (Exception ex) {
            // empty catch block
        }
        long offset = 0L;
        while (!ish5 && offset < fileSize) {
            try {
                raf.seek(offset);
                raf.read(header);
            }
            catch (Exception ex) {
                header = null;
            }
            if (header[0] == -119 && header[1] == 72 && header[2] == 68 && header[3] == 70 && header[4] == 13 && header[5] == 10 && header[6] == 26 && header[7] == 10) {
                ish5 = true;
                continue;
            }
            ish5 = false;
            if (offset == 0L) {
                offset = 512L;
                continue;
            }
            offset *= 2L;
        }
        try {
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return ish5;
    }

    public static boolean isNetcdf(String filename) {
        boolean isnc = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (Exception ex) {
            raf = null;
        }
        if (raf == null) {
            return false;
        }
        byte[] header = new byte[4];
        try {
            raf.read(header);
        }
        catch (Exception ex) {
            header = null;
        }
        if (header != null) {
            isnc = header[0] == 67 && header[1] == 68 && header[2] == 70 && header[3] == 1;
        }
        try {
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return isnc;
    }

    public static byte[] getHDF5UserBlock(String filename) {
        byte[] userBlock = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (Exception ex) {
            try {
                raf.close();
            }
            catch (Throwable err) {
                // empty catch block
            }
            raf = null;
        }
        if (raf == null) {
            return null;
        }
        byte[] header = new byte[8];
        long fileSize = 0L;
        try {
            fileSize = raf.length();
        }
        catch (Exception ex) {
            fileSize = 0L;
        }
        if (fileSize <= 0L) {
            try {
                raf.close();
            }
            catch (Throwable err) {
                // empty catch block
            }
            return null;
        }
        long offset = 0L;
        boolean ish5 = false;
        while (offset < fileSize) {
            try {
                raf.seek(offset);
                raf.read(header);
            }
            catch (Exception ex) {
                header = null;
            }
            if (header[0] == -119 && header[1] == 72 && header[2] == 68 && header[3] == 70 && header[4] == 13 && header[5] == 10 && header[6] == 26 && header[7] == 10) {
                ish5 = true;
                break;
            }
            ish5 = false;
            if (offset == 0L) {
                offset = 512L;
                continue;
            }
            offset *= 2L;
        }
        if (!ish5 || offset == 0L) {
            try {
                raf.close();
            }
            catch (Throwable err) {
                // empty catch block
            }
            return null;
        }
        int blockSize = (int)offset;
        userBlock = new byte[blockSize];
        try {
            raf.seek(0L);
            raf.read(userBlock, 0, blockSize);
        }
        catch (Exception ex) {
            userBlock = null;
        }
        try {
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return userBlock;
    }

    public static boolean setHDF5UserBlock(String fin, String fout, byte[] buf) {
        boolean ish5 = false;
        if (buf == null || buf.length <= 0) {
            return false;
        }
        File tmpFile = new File(fin);
        if (!tmpFile.exists()) {
            return false;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(fin, "r");
        }
        catch (Exception ex) {
            raf = null;
        }
        if (raf == null) {
            return false;
        }
        byte[] header = new byte[8];
        long fileSize = 0L;
        try {
            fileSize = raf.length();
        }
        catch (Exception ex) {
            fileSize = 0L;
        }
        try {
            fileSize = raf.length();
        }
        catch (Exception ex) {
            fileSize = 0L;
        }
        if (fileSize <= 0L) {
            try {
                raf.close();
            }
            catch (Throwable err) {
                // empty catch block
            }
            return false;
        }
        long offset = 0L;
        while (offset < fileSize) {
            try {
                raf.seek(offset);
                raf.read(header);
            }
            catch (Exception ex) {
                header = null;
            }
            if (header[0] == -119 && header[1] == 72 && header[2] == 68 && header[3] == 70 && header[4] == 13 && header[5] == 10 && header[6] == 26 && header[7] == 10) {
                ish5 = true;
                break;
            }
            ish5 = false;
            if (offset == 0L) {
                offset = 512L;
                continue;
            }
            offset *= 2L;
        }
        try {
            raf.close();
        }
        catch (Throwable err) {
            // empty catch block
        }
        if (!ish5) {
            return false;
        }
        int length = 0;
        int bsize = 1024;
        BufferedInputStream bi = null;
        FilterOutputStream bo = null;
        try {
            bi = new BufferedInputStream(new FileInputStream(fin));
        }
        catch (Exception ex) {
            try {
                bi.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return false;
        }
        try {
            bo = new BufferedOutputStream(new FileOutputStream(fout));
        }
        catch (Exception ex) {
            try {
                bo.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                bi.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return false;
        }
        try {
            bi.skip(offset);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ((BufferedOutputStream)bo).write(buf, 0, buf.length);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (offset = 512L; offset < (long)buf.length; offset *= 2L) {
        }
        int padSize = (int)(offset - (long)buf.length);
        if (padSize > 0) {
            byte[] padBuf = new byte[padSize];
            try {
                ((BufferedOutputStream)bo).write(padBuf, 0, padSize);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        byte[] buffer = new byte[bsize];
        try {
            length = bi.read(buffer, 0, bsize);
        }
        catch (Exception ex) {
            length = 0;
        }
        while (length > 0) {
            try {
                ((BufferedOutputStream)bo).write(buffer, 0, length);
                length = bi.read(buffer, 0, bsize);
            }
            catch (Exception ex) {
                length = 0;
            }
        }
        try {
            ((BufferedOutputStream)bo).flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            bi.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            bo.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return true;
    }
}

