/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.resources.Utilities;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleVisitor;
import org.opengis.util.Cloneable;

public class LineSymbolizerImpl
implements LineSymbolizer,
Cloneable {
    private Stroke stroke = null;
    private String geometryName = null;

    protected LineSymbolizerImpl() {
    }

    public String getGeometryPropertyName() {
        return this.geometryName;
    }

    public void setGeometryPropertyName(String name) {
        this.geometryName = name;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (this.stroke == stroke) {
            return;
        }
        this.stroke = stroke;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        LineSymbolizerImpl clone;
        try {
            clone = (LineSymbolizerImpl)super.clone();
            if (this.stroke != null && this.stroke instanceof Cloneable) {
                clone.stroke = (Stroke)((Cloneable)this.stroke).clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.stroke != null) {
            result = 1000003 * result + this.stroke.hashCode();
        }
        if (this.geometryName != null) {
            result = 1000003 * result + this.geometryName.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        LineSymbolizerImpl other = (LineSymbolizerImpl)oth;
        if (this.geometryName == null ? other.geometryName != null : !this.geometryName.equals(other.geometryName)) {
            return false;
        }
        return Utilities.equals((Object)this.getStroke(), (Object)other.getStroke());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<LineSymbolizerImp property=");
        buf.append(this.geometryName);
        buf.append(" stroke=");
        buf.append(this.stroke);
        buf.append(">");
        return buf.toString();
    }
}

