/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import javax.measure.converter.UnitConverter;

public final class LogConverter
extends UnitConverter {
    private final double _base;
    private final double _logBase;
    private final double _invLogBase;
    private final Inverse _inverse = new Inverse();
    private static final long serialVersionUID = 1L;

    public LogConverter(double base) {
        this._base = base;
        this._logBase = Math.log(base);
        this._invLogBase = 1.0 / this._logBase;
    }

    public double getBase() {
        return this._base;
    }

    public UnitConverter inverse() {
        return this._inverse;
    }

    public double convert(double amount) {
        return this._invLogBase * Math.log(amount);
    }

    public boolean isLinear() {
        return false;
    }

    private class Inverse
    extends UnitConverter {
        private static final long serialVersionUID = 1L;

        private Inverse() {
        }

        public UnitConverter inverse() {
            return LogConverter.this;
        }

        public double convert(double amount) {
            return Math.exp(LogConverter.this._logBase * amount);
        }

        public boolean isLinear() {
            return false;
        }
    }
}

