/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.Operation;
import nl.tudelft.simulation.dsol.interpreter.classfile.ExceptionEntry;

public class ATHROW
extends Operation {
    public static final int OP = 191;
    private int bytePosition = -1;

    public ATHROW(int bytePosition) {
        this.bytePosition = bytePosition;
    }

    public Frame execute(Frame frame) {
        Throwable throwable = (Throwable)frame.getOperandStack().pop();
        if (throwable == null) {
            throwable = new NullPointerException();
        }
        frame.getOperandStack().clear();
        frame.getOperandStack().push(throwable);
        ExceptionEntry[] exceptionEntries = frame.getMethodDescriptor().getExceptionTable();
        ExceptionEntry exceptionEntry = ExceptionEntry.resolveExceptionEntry(exceptionEntries, throwable.getClass(), this.bytePosition);
        frame.getOperandStack().push(exceptionEntry);
        return frame;
    }

    public int getByteLength() {
        return 1;
    }

    public int getOpcode() {
        return 191;
    }

    public void setBytePosition(int bytePosition) {
        this.bytePosition = bytePosition;
    }

    public int getBytePosition() {
        return this.bytePosition;
    }
}

