/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.classfile;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantUTF8;
import nl.tudelft.simulation.language.reflection.FieldSignature;

public class LocalVariableDescriptor {
    private int startByte = -1;
    private int length = -1;
    private int index = -1;
    private String name;
    private FieldSignature fieldSignature;

    public LocalVariableDescriptor(DataInput dataInput, Constant[] constantPool) throws IOException {
        this.startByte = dataInput.readUnsignedShort();
        this.length = dataInput.readUnsignedShort();
        this.name = ((ConstantUTF8)constantPool[dataInput.readUnsignedShort()]).getValue();
        this.fieldSignature = new FieldSignature(((ConstantUTF8)constantPool[dataInput.readUnsignedShort()]).getValue());
        this.index = dataInput.readUnsignedShort();
    }

    public FieldSignature getFieldSignature() {
        return this.fieldSignature;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public int getStartByte() {
        return this.startByte;
    }

    public String toString() {
        return "[" + this.name + ";" + this.fieldSignature + "]";
    }
}

