/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.classfile;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantClass;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantDouble;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantFieldref;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantFloat;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantInteger;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantInterfaceMethodref;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantLong;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantMethodref;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantNameAndType;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantString;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantUTF8;

public abstract class Constant {
    protected Constant[] constantPool = null;

    public Constant(Constant[] constantPool) {
        this.constantPool = constantPool;
    }

    public abstract int getTag();

    public static Constant readConstant(Constant[] constantPool, DataInput dataInput) throws IOException {
        int tag = dataInput.readUnsignedByte();
        switch (tag) {
            case 7: {
                return new ConstantClass(constantPool, dataInput);
            }
            case 9: {
                return new ConstantFieldref(constantPool, dataInput);
            }
            case 10: {
                return new ConstantMethodref(constantPool, dataInput);
            }
            case 11: {
                return new ConstantInterfaceMethodref(constantPool, dataInput);
            }
            case 8: {
                return new ConstantString(constantPool, dataInput);
            }
            case 3: {
                return new ConstantInteger(constantPool, dataInput);
            }
            case 4: {
                return new ConstantFloat(constantPool, dataInput);
            }
            case 5: {
                return new ConstantLong(constantPool, dataInput);
            }
            case 6: {
                return new ConstantDouble(constantPool, dataInput);
            }
            case 12: {
                return new ConstantNameAndType(constantPool, dataInput);
            }
            case 1: {
                return new ConstantUTF8(constantPool, dataInput);
            }
        }
        throw new IOException("unknow tag constant");
    }

    public static String toString(Constant[] constantPool) {
        String result = "";
        for (int i = 0; i < constantPool.length; ++i) {
            result = constantPool[i] != null ? result + i + ": " + constantPool[i].toString() + "\n" : result + i + ": empty \n";
        }
        return result;
    }
}

