/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import net.sourceforge.jeuclid.font.FontFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.util.ClasspathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultFontFactory
extends FontFactory {
    private static final int CACHE_FONT_SIZE = 12;
    private static final int NUM_STYLES = 4;
    private static final Log LOGGER = LogFactory.getLog(DefaultFontFactory.class);
    private final Map<String, Font[]> fontCache = new HashMap<String, Font[]>();

    DefaultFontFactory() {
        this.autoloadFontsFromAWT();
        this.autoloadFontsFromClasspath();
    }

    private void autoloadFontsFromAWT() {
        String[] stringArray;
        for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            for (int i = 0; i < 4; ++i) {
                Font font = new Font(string, i, 12);
                this.cacheFont(font);
            }
        }
    }

    private void autoloadFontsFromClasspath() {
        List list = ClasspathResource.getInstance().listResourcesOfMimeType("application/x-font");
        for (URL uRL : list) {
            try {
                try {
                    this.cacheFont(Font.createFont(0, uRL.openStream()));
                }
                catch (FontFormatException fontFormatException) {
                    try {
                        this.cacheFont(Font.createFont(1, uRL.openStream()));
                    }
                    catch (FontFormatException fontFormatException2) {
                        LOGGER.warn((Object)fontFormatException.getMessage());
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)iOException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Font getFont(String string, int n, float f) {
        Font font;
        Map<String, Font[]> map = this.fontCache;
        synchronized (map) {
            Font[] fontArray = this.fontCache.get(string.toLowerCase(Locale.ENGLISH));
            if (fontArray == null) {
                font = this.cacheFont(new Font(string, 0, 12)).deriveFont(n, f);
            } else {
                font = fontArray[n];
                if (font == null) {
                    fontArray[n] = font = fontArray[0].deriveFont(n, f);
                } else {
                    font = font.deriveFont(f);
                }
            }
        }
        return font;
    }

    @Override
    public Font getFont(List<String> list, int n, int n2, float f) {
        Font font = this.searchFontList(list, n, n2, f);
        if (font == null) {
            font = this.searchFontList(this.fontCache.keySet(), n, n2, f);
        }
        return font;
    }

    private Font searchFontList(Collection<String> collection, int n, int n2, float f) {
        for (String string : collection) {
            Font font = this.getFont(string, n2, f);
            String string2 = string.trim();
            if (!font.getFamily().equalsIgnoreCase(string2) && !font.getFontName().equalsIgnoreCase(string2) || !font.canDisplay(n)) continue;
            return font;
        }
        return null;
    }

    @Override
    public Font registerFont(int n, File file) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(n, file));
    }

    @Override
    public Font registerFont(int n, InputStream inputStream) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(n, inputStream));
    }

    private Font cacheFont(Font font) {
        String string = font.getFamily().trim().toLowerCase(Locale.ENGLISH);
        String string2 = font.getName().trim().toLowerCase(Locale.ENGLISH);
        int n = font.getStyle();
        if (string2.contains("italic")) {
            n |= 2;
        }
        if (string2.contains("oblique")) {
            n |= 2;
        }
        if (string2.contains("bold")) {
            n |= 1;
        }
        this.cacheFontWithStyle(font, string, n);
        this.cacheFontWithStyle(font, string2, n);
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFontWithStyle(Font font, String string, int n) {
        Map<String, Font[]> map = this.fontCache;
        synchronized (map) {
            Font[] fontArray = this.fontCache.get(string);
            if (fontArray == null) {
                fontArray = new Font[4];
                this.fontCache.put(string, fontArray);
                fontArray[0] = font;
            }
            fontArray[n] = font;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listFontNames() {
        HashSet<String> hashSet;
        Map<String, Font[]> map = this.fontCache;
        synchronized (map) {
            hashSet = new HashSet<String>(this.fontCache.keySet());
        }
        return hashSet;
    }
}

