/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gw.util.ProjectionNotFoundException;
import gw.util.TransformFailedException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ProjectionUtils {
    private static CoordinateReferenceSystem EPSG4326 = null;
    static final String wkt = "GEOGCS[\"WGS 84\", DATUM[\"WGS_1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Longitude\", EAST], AXIS[\"Latitude\", NORTH], AUTHORITY[\"EPSG\",\"4326\"]]";

    public static CoordinateReferenceSystem getDefaultCRS() {
        if (EPSG4326 == null) {
            try {
                EPSG4326 = CRS.parseWKT((String)wkt);
            }
            catch (FactoryException factory) {
                factory.printStackTrace();
            }
        }
        return EPSG4326;
    }

    public static double[] latLonToProjection(LatLon latlon, CoordinateReferenceSystem targetCRS) {
        double[] a = new double[]{latlon.getLongitude().getDegrees(), latlon.getLatitude().getDegrees()};
        double[] b = new double[]{0.0, 0.0};
        try {
            CRS.findMathTransform((CoordinateReferenceSystem)ProjectionUtils.getDefaultCRS(), (CoordinateReferenceSystem)targetCRS, (boolean)true).transform(a, 0, b, 0, 1);
        }
        catch (FactoryException factoryEx) {
            throw new ProjectionNotFoundException(factoryEx);
        }
        catch (TransformException trans) {
            throw new TransformFailedException(trans);
        }
        return b;
    }

    public static LatLon toLatLon(double[] point, CoordinateReferenceSystem originalCRS) {
        double[] result = new double[]{0.0, 0.0};
        try {
            CRS.findMathTransform((CoordinateReferenceSystem)originalCRS, (CoordinateReferenceSystem)ProjectionUtils.getDefaultCRS(), (boolean)true).transform(point, 0, result, 0, 1);
        }
        catch (FactoryException factoryEx) {
            throw new ProjectionNotFoundException(factoryEx);
        }
        catch (TransformException trans) {
            throw new TransformFailedException(trans);
        }
        return LatLon.fromDegrees((double)result[1], (double)result[0]);
    }

    public static ReferencedEnvelope transformEnvelope(Envelope env, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        double[] minLL = new double[]{env.getMinimum(0), env.getMinimum(1)};
        double[] maxLL = new double[]{env.getMaximum(0), env.getMaximum(1)};
        double[] a = new double[]{0.0, 0.0};
        double[] b = new double[]{0.0, 0.0};
        try {
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            mt.transform(minLL, 0, a, 0, 1);
            mt.transform(maxLL, 0, b, 0, 1);
        }
        catch (FactoryException factoryEx) {
            throw new ProjectionNotFoundException(factoryEx);
        }
        catch (TransformException trans) {
            throw new TransformFailedException(trans);
        }
        return new ReferencedEnvelope(a[0], b[0], a[1], b[1], targetCRS);
    }

    public static Sector transformSector(Sector s, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        double[] minLL = new double[]{s.getMinLongitude().getDegrees(), s.getMinLatitude().getDegrees()};
        double[] maxLL = new double[]{s.getMaxLongitude().getDegrees(), s.getMaxLatitude().getDegrees()};
        double[] a = new double[]{0.0, 0.0};
        double[] b = new double[]{0.0, 0.0};
        try {
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            mt.transform(minLL, 0, a, 0, 1);
            mt.transform(maxLL, 0, b, 0, 1);
        }
        catch (FactoryException factoryEx) {
            throw new ProjectionNotFoundException(factoryEx);
        }
        catch (TransformException trans) {
            throw new TransformFailedException(trans);
        }
        return Sector.fromDegrees((double)a[1], (double)b[1], (double)a[0], (double)b[0]);
    }
}

