/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Scanner;

public class AnimationFile {
    String[] columns;
    String[] columnTypes;
    ArrayList<Timestep> animationData = new ArrayList();

    public Timestep getTimestep(int i) {
        return this.animationData.get(i);
    }

    public int getTimestepCount() {
        return this.animationData.size();
    }

    public AnimationFile(String filename) throws Exception {
        boolean headerRead = false;
        boolean typesRead = false;
        File file = new File(filename);
        Scanner scanner = new Scanner(file);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            Scanner lineScanner = new Scanner(line);
            if (line.startsWith("#")) continue;
            if (!headerRead) {
                this.columns = this.processHeader(lineScanner);
                headerRead = true;
                continue;
            }
            if (!typesRead) {
                this.columnTypes = this.processTypes(lineScanner);
                typesRead = true;
                continue;
            }
            this.processLine(lineScanner);
        }
    }

    private String[] tokens(Scanner lineScanner) {
        ArrayList<String> strings = new ArrayList<String>();
        while (lineScanner.hasNext()) {
            String next = lineScanner.next();
            strings.add(next);
        }
        String[] out = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            out[i] = (String)strings.get(i);
        }
        return out;
    }

    private String[] processHeader(Scanner lineScanner) {
        return this.tokens(lineScanner);
    }

    private String[] processTypes(Scanner lineScanner) {
        return this.tokens(lineScanner);
    }

    private Timestep currentTimestep() {
        if (this.animationData.size() == 0) {
            return null;
        }
        return this.animationData.get(this.animationData.size() - 1);
    }

    private void processLine(Scanner lineScanner) {
        String[] tokens = this.tokens(lineScanner);
        if (this.currentTimestep() == null) {
            this.animationData.add(new Timestep(tokens));
        } else if (this.currentTimestep().dateMatches(tokens[0])) {
            this.currentTimestep().read(tokens);
        } else {
            this.animationData.add(new Timestep(tokens));
        }
    }

    public double getMinDouble(int colIndex) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.getTimestepCount(); ++i) {
            for (String[] line : this.getTimestep((int)i).data) {
                double d = Double.parseDouble(line[colIndex]);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return min;
    }

    public double getMaxDouble(int colIndex) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.getTimestepCount(); ++i) {
            for (String[] line : this.getTimestep((int)i).data) {
                double d = Double.parseDouble(line[colIndex]);
                if (!(d > max)) continue;
                max = d;
            }
        }
        return max;
    }

    public class Timestep {
        public String timestamp;
        public ArrayList<String[]> data = new ArrayList();

        public Timestep(String[] tokens) {
            this.timestamp = tokens[0];
            this.read(tokens);
        }

        public boolean dateMatches(String date) {
            return this.timestamp.equals(date);
        }

        public void read(String[] tokens) {
            this.data.add(tokens);
        }

        public String[] match(int attrCol, String attrValue) {
            for (int i = 0; i < this.data.size(); ++i) {
                String[] line = this.data.get(i);
                if (!line[attrCol].equals(attrValue)) continue;
                return line;
            }
            return null;
        }
    }
}

