/*
 * Decompiled with CFR 0.152.
 */
package gw.renderables.experimental;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import javax.media.opengl.GL;

public class BillboardList
implements Renderable {
    LatLon[] points;
    float size;
    String imagename;

    public BillboardList(LatLon[] points, float size, String imagename) {
        this.points = points;
        this.size = size;
        this.imagename = imagename;
    }

    private void drawBillboard(DrawContext dc) {
        dc.drawUnitQuad();
    }

    public void render(DrawContext dc) {
        Globe globe = dc.getGlobe();
        GL gl = dc.getGL();
        gl.glPushMatrix();
        Vec4 eyePoint = dc.getView().getEyePoint();
        float[] modelview = new float[16];
        gl.glGetFloatv(2982, modelview, 0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                modelview[i * 4 + j] = i == j ? 1.0f : 0.0f;
            }
        }
        gl.glLoadMatrixf(modelview, 0);
        for (LatLon ll : this.points) {
            double elevation = globe.getElevationModel().getElevation(ll.getLatitude(), ll.getLongitude());
            Vec4 objPos = globe.computePointFromPosition(ll.getLatitude(), ll.getLongitude(), elevation);
            gl.glPushMatrix();
            gl.glPointSize(5.0f);
            gl.glBegin(0);
            gl.glVertex3d(objPos.x, objPos.y, objPos.z);
            gl.glEnd();
            gl.glPopMatrix();
        }
        gl.glPopMatrix();
    }
}

