/*
 * Decompiled with CFR 0.152.
 */
package gw.renderables;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class LinePath
implements Renderable {
    private Position[] vertices;
    private Color color;
    int displayList = -1;
    int refreshCounter = 0;
    int refreshTime = 120;
    int lineWidth = 1;
    boolean elevationAbsolute = true;

    public LinePath(Position[] vertices, Color color) {
        this.vertices = vertices;
        this.color = color;
    }

    public LinePath(Position[] vertices, Color color, int lineWidth, boolean absElevation) {
        this.vertices = vertices;
        this.color = color;
        this.lineWidth = lineWidth;
        this.elevationAbsolute = absElevation;
    }

    private void drawPrimitives(DrawContext dc) {
        GL gl = dc.getGL();
        GLU glu = dc.getGLU();
        Globe myglobe = dc.getGlobe();
        gl.glPushAttrib(1 | 0x2000);
        gl.glDisable(3553);
        gl.glDisable(2929);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glLineWidth((float)this.lineWidth);
        gl.glBegin(3);
        gl.glColor4d((double)this.color.getRed() / 255.0, (double)this.color.getGreen() / 255.0, (double)this.color.getBlue() / 255.0, (double)this.color.getAlpha() / 255.0);
        for (int i = 0; i < this.vertices.length; ++i) {
            double elevation = this.vertices[i].getElevation();
            if (!this.elevationAbsolute) {
                elevation += myglobe.getElevation(this.vertices[i].getLatitude(), this.vertices[i].getLongitude());
            }
            Position upvec = Position.fromDegrees((double)0.0, (double)0.0, (double)0.0);
            Vec4 point = myglobe.computePointFromPosition(this.vertices[i].add(upvec));
            gl.glVertex3d(point.x, point.y, point.z);
        }
        gl.glLineWidth(1.0f);
        gl.glEnd();
        gl.glPopAttrib();
    }

    public void render(DrawContext dc) {
        boolean regenerate = false;
        GL gl = dc.getGL();
        if (this.displayList == -1) {
            this.displayList = gl.glGenLists(1);
            regenerate = true;
        }
        if (this.refreshCounter >= this.refreshTime) {
            regenerate = true;
            this.refreshCounter = 0;
        }
        if (regenerate) {
            gl.glNewList(this.displayList, 4864);
            this.drawPrimitives(dc);
            gl.glEndList();
        }
        gl.glCallList(this.displayList);
        ++this.refreshCounter;
    }
}

