/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Renderable;
import gw.layers.SimpleFeatureLayer;
import gw.util.GeoToolsUtils;
import gw.util.StyleInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.io.IOException;
import org.geotools.feature.FeatureIterator;
import org.geotools.styling.StyleVisitor;
import org.opengis.feature.simple.SimpleFeature;

public class SimpleFeatureAnnotationLayer
extends RenderableLayer {
    public SimpleFeatureAnnotationLayer(SimpleFeatureLayer base) throws IOException {
        this.constructUsingStyle(base);
    }

    public SimpleFeatureAnnotationLayer(SimpleFeatureLayer base, String[] text) throws IOException {
        Renderable[] renderables;
        for (Renderable r : renderables = SimpleFeatureAnnotationLayer.buildLabels(base, text)) {
            if (r == null) continue;
            this.addRenderable(r);
        }
    }

    public static Renderable[] buildLabels(SimpleFeatureLayer base, String[] text) {
        Renderable[] rval = new Renderable[text.length];
        Class type = base.getSchema().getGeometryDescriptor().getType().getBinding();
        for (int i = 0; i < base.getFeatures().length; ++i) {
            Position center = GeoToolsUtils.getFeatureCenter(base.getFeatures()[i], base.getCRS());
            GlobeAnnotation ga = new GlobeAnnotation(text[i], Position.fromDegrees((double)center.getLatitude().getDegrees(), (double)center.getLongitude().getDegrees(), (double)0.0));
            ga.getAttributes().setInsets(new Insets(1, 1, 1, 1));
            ga.getAttributes().setBorderColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            ga.getAttributes().setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            ga.getAttributes().setTextColor(Color.WHITE);
            ga.getAttributes().setDrawOffset(new Point(0, 0));
            rval[i] = ga;
        }
        return rval;
    }

    public void constructUsingStyle(SimpleFeatureLayer base) throws IOException {
        StyleInfo info = new StyleInfo();
        base.getStyle().accept((StyleVisitor)info);
        Class type = base.getSchema().getGeometryDescriptor().getType().getBinding();
        if (type.isAssignableFrom(Polygon.class) || type.isAssignableFrom(MultiPolygon.class)) {
            FeatureIterator i = base.getFeatureSource().getFeatures().features();
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                Color backgroundColor = Color.BLACK;
                Color textColor = Color.WHITE;
                org.geotools.styling.Font[] fonts = info.getTextFonts();
                if (info.getTextFill().getBackgroundColor() != null) {
                    backgroundColor = Color.decode((String)info.getTextFill().getBackgroundColor().evaluate((Object)feature));
                }
                if (info.getTextFill().getColor() != null) {
                    textColor = Color.decode((String)info.getTextFill().getColor().evaluate((Object)feature));
                }
                if (info.getTextFill().getOpacity() != null) {
                    Double d = (Double)info.getTextFill().getOpacity().evaluate((Object)feature);
                }
                if (info.getLabel() == null) continue;
                String text = info.getLabel().evaluate((Object)feature).toString();
                Position center = GeoToolsUtils.getFeatureCenter(feature, base.getCRS());
                GlobeAnnotation ga = new GlobeAnnotation(text, center);
                ga.getAttributes().setBorderColor(Color.BLACK);
                ga.getAttributes().setBackgroundColor(backgroundColor);
                ga.getAttributes().setTextColor(textColor);
                if (fonts != null && fonts.length > 0) {
                    String fontName = fonts[0].getFontFamily().evaluate((Object)feature).toString();
                    double fontSize = Double.parseDouble(fonts[0].getFontSize().evaluate((Object)feature).toString());
                    String fontStyle = fonts[0].getFontStyle().evaluate((Object)feature).toString();
                    ga.getAttributes().setFont(new Font(fontName, 0, (int)fontSize));
                }
                this.addRenderable((Renderable)ga);
            }
        }
    }
}

