/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import gw.util.ProjectionUtils;
import gw.util.ShapeUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.map.MapContext;
import org.opengis.feature.simple.SimpleFeature;

public class PointLayer
extends IconLayer
implements SelectListener {
    Sector sector;
    private ArrayList<Spot> spots = new ArrayList();
    String tooltipFont = "Tahoma-12";
    String iconFilename;

    public PointLayer(Spot[] points, WorldWindow canvas, String iconFilename) {
        this.iconFilename = iconFilename;
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (Spot p : points) {
            this.spots.add(p);
            LatLon ll = p.getPosition();
            double lat = ll.getLatitude().getDegrees();
            double lon = ll.getLongitude().getDegrees();
            this.addIconForSpot(p);
            if (lat < minLat) {
                minLat = lat;
            }
            if (lon < minLon) {
                minLon = lon;
            }
            if (lat > maxLat) {
                maxLat = lat;
            }
            if (!(lon > maxLon)) continue;
            maxLon = lon;
        }
        this.sector = Sector.fromDegrees((double)minLat, (double)maxLat, (double)minLon, (double)maxLon);
        canvas.addSelectListener((SelectListener)this);
        this.setMaxActiveAltitude(100000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Spot[] spotsFromShapefile(File file) throws MalformedURLException, IOException {
        ShapefileDataStore shapefile = new ShapefileDataStore(file.toURL());
        MapContext map = ShapeUtils.createMapContext(file, shapefile.getFeatureSource());
        if (map.getCoordinateReferenceSystem() == null) {
            throw new IOException("Shape file does not have a projection");
        }
        String[] typeNames = shapefile.getTypeNames();
        FeatureSource featureSource = shapefile.getFeatureSource(typeNames[0]);
        FeatureCollection collection = featureSource.getFeatures();
        FeatureIterator iterator = null;
        Spot[] spots = new Spot[collection.size()];
        int i = 0;
        try {
            iterator = collection.features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Point center = ((Geometry)feature.getDefaultGeometry()).getCentroid();
                LatLon ll = ProjectionUtils.toLatLon(new double[]{center.getX(), center.getY()}, map.getCoordinateReferenceSystem());
                spots[i++] = new Spot(ll, feature.toString(), feature);
            }
        }
        finally {
            iterator.close();
        }
        return spots;
    }

    private Font makeToolTipFont() {
        HashMap<TextAttribute, Color> fontAttributes = new HashMap<TextAttribute, Color>();
        fontAttributes.put(TextAttribute.BACKGROUND, new Color(1.0f, 1.0f, 1.0f, 1.0f));
        return Font.decode(this.tooltipFont).deriveFont(fontAttributes);
    }

    private void addIconForSpot(Spot s) {
        LatLon ll = s.getPosition();
        UserFacingIcon icon = new UserFacingIcon(this.iconFilename, new Position(ll.getLatitude(), ll.getLongitude(), 0.0));
        icon.setSize(new Dimension(32, 32));
        icon.setHighlightScale(1.25);
        icon.setToolTipFont(this.makeToolTipFont());
        icon.setToolTipText(s.getDescription());
        icon.setToolTipTextColor(Color.BLACK);
        icon.setShowToolTip(false);
        s.setIcon((WWIcon)icon);
        this.addIcon((WWIcon)icon);
    }

    public void calculateSector() {
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (Spot p : this.getSpots()) {
            LatLon ll = p.getPosition();
            double lat = ll.getLatitude().getDegrees();
            double lon = ll.getLongitude().getDegrees();
            if (lat < minLat) {
                minLat = lat;
            }
            if (lon < minLon) {
                minLon = lon;
            }
            if (lat > maxLat) {
                maxLat = lat;
            }
            if (!(lon > maxLon)) continue;
            maxLon = lon;
        }
        this.sector = Sector.fromDegrees((double)minLat, (double)maxLat, (double)minLon, (double)maxLon);
    }

    public Spot getSpotByTag(Object tag) {
        for (Spot spot : this.getSpots()) {
            if (spot.getTag() != tag) continue;
            return spot;
        }
        return null;
    }

    public void addSpot(Spot s) {
        this.getSpots().add(s);
        this.addIconForSpot(s);
        this.calculateSector();
    }

    public void removeSpot(Spot s) {
        this.getSpots().remove(s);
        this.removeIcon(s.getIcon());
        this.calculateSector();
    }

    public void selected(SelectEvent event) {
        WWIcon myIcon;
        for (WWIcon ico : this.getIcons()) {
            ico.setHighlighted(false);
            ico.setShowToolTip(false);
        }
        if (event.getTopPickedObject() != null && event.getTopPickedObject().getObject() instanceof WWIcon && (myIcon = (WWIcon)event.getTopPickedObject().getObject()) != null) {
            myIcon.setHighlighted(true);
            myIcon.setShowToolTip(true);
        }
    }

    public Sector getSector() {
        return this.sector;
    }

    public ArrayList<Spot> getSpots() {
        return this.spots;
    }

    public void setSpots(ArrayList<Spot> spots) {
        this.spots = spots;
    }

    public static class Spot {
        private LatLon position;
        private String description;
        private Object tag;
        private WWIcon icon;

        public Spot(LatLon position, String description, Object tag) {
            this.position = position;
            this.description = description;
            this.tag = tag;
        }

        public LatLon getPosition() {
            return this.position;
        }

        public void setPosition(LatLon position) {
            this.position = position;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Object getTag() {
            return this.tag;
        }

        public void setTag(Object tag) {
            this.tag = tag;
        }

        public WWIcon getIcon() {
            return this.icon;
        }

        public void setIcon(WWIcon icon) {
            this.icon = icon;
        }
    }
}

