/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import gov.nasa.worldwind.WorldWindow;
import gw.layers.AnimatedSimpleFeatureLayer;
import gw.layers.GridCoverageLayer;
import gw.layers.PointLayer;
import gw.layers.SimpleFeatureLayer;
import gw.util.AnimationFile;
import gw.util.StyleUtils;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class LayerFactory {
    private LayerFactory() {
    }

    public static SimpleFeatureLayer fromShapefile(File shpFile, WorldWindow window) throws IOException, MalformedURLException {
        if (!shpFile.exists()) {
            throw new IllegalArgumentException(shpFile.toString());
        }
        ShapefileDataStore shapeStore = new ShapefileDataStore(shpFile.toURI().toURL());
        FeatureSource featureSource = shapeStore.getFeatureSource();
        Style s = StyleUtils.createStyle(shpFile, featureSource.getSchema());
        return new SimpleFeatureLayer(shpFile.getName(), (FeatureSource<SimpleFeatureType, SimpleFeature>)featureSource, s, window, 512);
    }

    public static AnimatedSimpleFeatureLayer fromFile(File shpFile, AnimationFile animationFile, WorldWindow window) throws IOException, MalformedURLException {
        if (!shpFile.exists()) {
            throw new IllegalArgumentException(shpFile.toString());
        }
        ShapefileDataStore shapeStore = new ShapefileDataStore(shpFile.toURI().toURL());
        FeatureSource featureSource = shapeStore.getFeatureSource();
        Style s = StyleUtils.createStyle(shpFile, featureSource.getSchema());
        return new AnimatedSimpleFeatureLayer(shpFile.getName(), (FeatureSource<SimpleFeatureType, SimpleFeature>)featureSource, s, window, animationFile);
    }

    public static GridCoverageLayer fromGeotiff(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException(file.toString());
        }
        GeoTiffReader reader = new GeoTiffReader((Object)file, new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        GridCoverage2D coverage = (GridCoverage2D)reader.read(null);
        return new GridCoverageLayer(file.getName(), coverage);
    }

    public static PointLayer spotLayer(PointLayer.Spot[] points, WorldWindow window, String iconFilename) {
        return new PointLayer(points, window, iconFilename);
    }
}

