/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gw.renderables.ElevatedSurfaceImage;
import gw.util.ProjectionUtils;
import gw.util.WorldWindUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedImageAdapter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridCoverageLayer
extends RenderableLayer {
    GridCoverage2D coverage;
    CoordinateReferenceSystem crs;
    Sector projectedSector;
    ElevatedSurfaceImage surfaceImage;

    public GridCoverageLayer(String name, GridCoverage2D coverage) {
        this.coverage = coverage;
        this.crs = coverage.getCoordinateReferenceSystem2D();
        RenderedImage rimage = coverage.getRenderedImage();
        RenderedImageAdapter ria = new RenderedImageAdapter(rimage);
        BufferedImage image = ria.getAsBufferedImage();
        this.projectedSector = WorldWindUtils.sectorFromEnvelope((Envelope)ProjectionUtils.transformEnvelope(coverage.getEnvelope(), this.crs, ProjectionUtils.getDefaultCRS()));
        this.surfaceImage = new ElevatedSurfaceImage(image, this.projectedSector);
        this.surfaceImage.setFloating(false);
        this.addRenderable((Renderable)this.surfaceImage);
        this.surfaceImage.setOpacity(1.0);
        this.setName(name);
    }

    public double getElevation() {
        return this.surfaceImage.getElevation();
    }

    public void setElevation(double elev) {
        this.surfaceImage.setElevation(elev);
    }

    public boolean getFloating() {
        return this.surfaceImage.getFloating();
    }

    public void setFloating(boolean floating) {
        this.surfaceImage.setFloating(floating);
    }

    public double getOpacity() {
        return this.surfaceImage.getOpacity();
    }

    public void setOpacity(double value) {
        this.surfaceImage.setOpacity(value);
    }

    public Sector getSector() {
        return this.projectedSector;
    }

    public String toString() {
        return this.getName();
    }
}

