/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.ShapeFlatnessTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

public class TransformingGraphics
extends GraphicsDecorator {
    protected BidirectionalTransformer transformer;

    public TransformingGraphics(BidirectionalTransformer transformer) {
        this(transformer, null);
    }

    public TransformingGraphics(BidirectionalTransformer transformer, Graphics2D delegate) {
        super(delegate);
        this.transformer = transformer;
    }

    public BidirectionalTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(BidirectionalTransformer transformer) {
        this.transformer = transformer;
    }

    public void draw(Shape s) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.draw(shape);
    }

    public void draw(Shape s, float flatness) {
        Shape shape = null;
        shape = this.transformer instanceof ShapeFlatnessTransformer ? ((ShapeFlatnessTransformer)this.transformer).transform(s, flatness) : ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.draw(shape);
    }

    public void fill(Shape s) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.fill(shape);
    }

    public void fill(Shape s, float flatness) {
        Shape shape = null;
        shape = this.transformer instanceof ShapeFlatnessTransformer ? ((ShapeFlatnessTransformer)this.transformer).transform(s, flatness) : ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.fill(shape);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        Image image = null;
        if (this.transformer instanceof ShapeFlatnessTransformer) {
            Rectangle2D.Double r = new Rectangle2D.Double(x, y, img.getWidth(observer), img.getHeight(observer));
            Rectangle2D s = ((ShapeTransformer)this.transformer).transform(r).getBounds2D();
            image = img.getScaledInstance((int)s.getWidth(), (int)s.getHeight(), 4);
            x = (int)s.getMinX();
            y = (int)s.getMinY();
        } else {
            image = img;
        }
        return this.delegate.drawImage(image, x, y, observer);
    }

    public boolean drawImage(Image img, AffineTransform at, ImageObserver observer) {
        Image image = null;
        int x = (int)at.getTranslateX();
        int y = (int)at.getTranslateY();
        if (this.transformer instanceof ShapeFlatnessTransformer) {
            Rectangle2D.Double r = new Rectangle2D.Double(x, y, img.getWidth(observer), img.getHeight(observer));
            Rectangle2D s = ((ShapeTransformer)this.transformer).transform(r).getBounds2D();
            image = img.getScaledInstance((int)s.getWidth(), (int)s.getHeight(), 4);
            x = (int)s.getMinX();
            y = (int)s.getMinY();
            at.setToTranslation(s.getMinX(), s.getMinY());
        } else {
            image = img;
        }
        return this.delegate.drawImage(image, at, observer);
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s);
        return this.delegate.hit(rect, shape, onStroke);
    }

    public Graphics create() {
        return this.delegate.create();
    }

    public void dispose() {
        this.delegate.dispose();
    }
}

