/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import org.encog.engine.util.EngineArray;
import org.encog.engine.util.ObjectPair;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrainingSetUtil {
    public static NeuralDataSet loadCSVTOMemory(CSVFormat cSVFormat, String string, boolean bl, int n, int n2) {
        BasicNeuralDataSet basicNeuralDataSet = new BasicNeuralDataSet();
        ReadCSV readCSV = new ReadCSV(string, bl, cSVFormat);
        while (readCSV.next()) {
            double d;
            int n3;
            BasicNeuralData basicNeuralData = null;
            BasicNeuralData basicNeuralData2 = null;
            int n4 = 0;
            basicNeuralData = new BasicNeuralData(n);
            for (n3 = 0; n3 < n; ++n3) {
                d = readCSV.getDouble(n4++);
                basicNeuralData.setData(n3, d);
            }
            if (n > 0) {
                basicNeuralData2 = new BasicNeuralData(n);
                for (n3 = 0; n3 < n2; ++n3) {
                    d = readCSV.getDouble(n4++);
                    basicNeuralData2.setData(n3, d);
                }
            }
            BasicNeuralDataPair basicNeuralDataPair = new BasicNeuralDataPair(basicNeuralData, basicNeuralData2);
            basicNeuralDataSet.add(basicNeuralDataPair);
        }
        return basicNeuralDataSet;
    }

    public static ObjectPair<double[][], double[][]> trainingToArray(NeuralDataSet neuralDataSet) {
        int n = TrainingSetUtil.trainingSetSize(neuralDataSet);
        double[][] dArray = new double[n][neuralDataSet.getInputSize()];
        double[][] dArray2 = new double[n][neuralDataSet.getIdealSize()];
        int n2 = 0;
        for (NeuralDataPair neuralDataPair : neuralDataSet) {
            EngineArray.arrayCopy(neuralDataPair.getInputArray(), dArray[n2]);
            EngineArray.arrayCopy(neuralDataPair.getIdealArray(), dArray2[n2]);
            ++n2;
        }
        return new ObjectPair<double[][], double[][]>(dArray, dArray2);
    }

    public static int trainingSetSize(NeuralDataSet neuralDataSet) {
        if (neuralDataSet instanceof Indexable) {
            return (int)((Indexable)neuralDataSet).getRecordCount();
        }
        int n = 0;
        for (NeuralDataPair neuralDataPair : neuralDataSet) {
            ++n;
        }
        return n;
    }
}

