/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.encog.engine.util.Format;

public class TrainingDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6847676575773420316L;
    private JLabel labelError;
    private JLabel labelIterations;
    private JLabel labelTime;
    private JButton buttonStop;
    private boolean shouldStop = false;

    public TrainingDialog() {
        this.setSize(320, 100);
        this.setTitle("Training");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2));
        jPanel.add(new JLabel("Current Error:"));
        this.labelError = new JLabel("Starting...");
        jPanel.add(this.labelError);
        jPanel.add(new JLabel("Iterations:"));
        this.labelIterations = new JLabel("");
        jPanel.add(this.labelIterations);
        jPanel.add(new JLabel("Training Time:"));
        this.labelTime = new JLabel("");
        jPanel.add(this.labelTime);
        this.buttonStop = new JButton("Stop");
        container.add((Component)this.buttonStop, "South");
        container.add((Component)jPanel, "Center");
        this.buttonStop.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonStop) {
            this.buttonStop.setEnabled(false);
            this.buttonStop.setText("Stopping...");
            this.shouldStop = true;
        }
    }

    public void setError(double d) {
        this.labelError.setText(Format.formatPercent(d));
    }

    public void setIterations(int n) {
        this.labelIterations.setText(Format.formatInteger(n));
    }

    public void setTime(int n) {
        this.labelTime.setText(Format.formatTimeSpan(n));
    }

    public boolean shouldStop() {
        return this.shouldStop;
    }
}

