/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.obj;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.location.ResourcePersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private static Map<String, Class<?>> classMap = new HashMap();

    public static Field findField(Class<?> clazz, String string) {
        Collection<Field> collection = ReflectionUtil.getAllFields(clazz);
        for (Field field : collection) {
            if (!field.getName().equals(string)) continue;
            field.setAccessible(true);
            return field;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectionUtil.findField(clazz.getSuperclass(), string);
        }
        return null;
    }

    public static Collection<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ReflectionUtil.getAllFields(clazz, arrayList);
        return arrayList;
    }

    public static void getAllFields(Class<?> clazz, Collection<Field> collection) {
        for (Field field : clazz.getDeclaredFields()) {
            collection.add(field);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            ReflectionUtil.getAllFields(clazz2, collection);
        }
    }

    public static boolean isInstanceOf(Class<?> clazz, Class<?> clazz2) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            if (!clazz3.equals(clazz)) continue;
            return true;
        }
        if (clazz.getSuperclass() == null) {
            return false;
        }
        return ReflectionUtil.isInstanceOf(clazz.getSuperclass(), clazz2);
    }

    public static boolean isPrimitive(Object object) {
        return object instanceof Character || object instanceof Integer || object instanceof Short || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof Long;
    }

    public static boolean isSimple(Object object) {
        return object instanceof File || object instanceof String;
    }

    public static void loadClassmap() {
        String string = null;
        try {
            String string2;
            ResourcePersistence resourcePersistence = new ResourcePersistence("org/encog/data/classes.txt");
            InputStream inputStream = resourcePersistence.createInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() == 0) continue;
                string = string2;
                Class<?> clazz = Class.forName(string2);
                classMap.put(clazz.getSimpleName(), clazz);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new EncogError(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new EncogError("Unknown class: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> resolveEncogClass(String string) {
        Map<String, Class<?>> map = classMap;
        synchronized (map) {
            if (classMap.size() == 0) {
                ReflectionUtil.loadClassmap();
            }
        }
        map = classMap;
        return classMap.get(string);
    }

    public static boolean shouldAccessField(Field field, boolean bl) {
        if (field.getAnnotation(EGIgnore.class) != null) {
            return false;
        }
        if ((field.getModifiers() & 8) == 0) {
            return !bl || !field.getName().equalsIgnoreCase("name") && !field.getName().equalsIgnoreCase("description");
        }
        return false;
    }

    private ReflectionUtil() {
    }

    public static Object resolveEnum(Field field, String string) {
        ?[] objArray;
        Class<?> clazz = field.getType();
        for (Object obj : objArray = clazz.getEnumConstants()) {
            if (!obj.toString().equals(string)) continue;
            return obj;
        }
        return null;
    }

    public static <T> int safeHashCode(T t) {
        if (t == null) {
            return 0;
        }
        return t.hashCode();
    }
}

