/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.logging;

import java.text.NumberFormat;
import org.encog.mathutil.matrices.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DumpMatrix {
    public static final int MAX_PRECIS = 3;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static String dumpArray(double[] dArray) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMaximumFractionDigits(3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(numberFormat.format(dArray[i]));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String dumpMatrix(Matrix matrix) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMaximumFractionDigits(3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==");
        stringBuilder.append(matrix.toString());
        stringBuilder.append("==\n");
        for (int i = 0; i < matrix.getRows(); ++i) {
            stringBuilder.append("  [");
            for (int j = 0; j < matrix.getCols(); ++j) {
                if (j != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(numberFormat.format(matrix.get(i, j)));
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    private DumpMatrix() {
    }
}

