/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.downsample;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import org.encog.EncogError;
import org.encog.util.downsample.RGBDownsample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIntensityDownsample
extends RGBDownsample {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public double[] downSample(Image image, int n, int n2) {
        this.processImage(image);
        double[] dArray = new double[n * n2 * 3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.getImageWidth(), this.getImageHeight(), true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)interruptedException);
            }
            throw new EncogError(interruptedException);
        }
        this.setPixelMap((int[])pixelGrabber.getPixels());
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.downSampleRegion(j, i);
                dArray[n3++] = (this.getCurrentRed() + this.getCurrentBlue() + this.getCurrentGreen()) / 3;
            }
        }
        return dArray;
    }
}

